/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.hud.TooltipHandler;
import mcp.mobius.waila.gui.screen.HomeScreen;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.service.IClientService;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public abstract class WailaClient {
    public static boolean showComponentBounds = false;
    public static KeyMapping keyOpenConfig;
    public static KeyMapping keyShowOverlay;
    public static KeyMapping keyToggleLiquid;
    public static KeyMapping keyShowRecipeInput;
    public static KeyMapping keyShowRecipeOutput;
    public static Runnable onShowRecipeInput;
    public static Runnable onShowRecipeOutput;

    protected static void registerKeyBinds() {
        keyOpenConfig = WailaClient.createKeyBind("config");
        keyShowOverlay = WailaClient.createKeyBind("show_overlay");
        keyToggleLiquid = WailaClient.createKeyBind("toggle_liquid");
        keyShowRecipeInput = WailaClient.createKeyBind("show_recipe_input");
        keyShowRecipeOutput = WailaClient.createKeyBind("show_recipe_output");
    }

    protected static void onClientTick() {
        Minecraft client = Minecraft.m_91087_();
        WailaConfig config = Waila.CONFIG.get();
        TooltipHandler.tick();
        while (keyOpenConfig.m_90859_()) {
            client.m_91152_((Screen)new HomeScreen(null));
        }
        while (keyShowOverlay.m_90859_()) {
            if (config.getGeneral().getDisplayMode() != IWailaConfig.General.DisplayMode.TOGGLE) continue;
            config.getGeneral().setDisplayTooltip(!config.getGeneral().isDisplayTooltip());
        }
        while (keyToggleLiquid.m_90859_()) {
            PluginConfig.set(WailaConstants.CONFIG_SHOW_FLUID, !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_FLUID));
        }
        while (keyShowRecipeInput.m_90859_() && onShowRecipeInput != null) {
            onShowRecipeInput.run();
        }
        while (keyShowRecipeOutput.m_90859_() && onShowRecipeOutput != null) {
            onShowRecipeOutput.run();
        }
    }

    protected static void onItemTooltip(ItemStack stack, List<Component> tooltip) {
        if (PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                String name = listener.getHoveredItemModName(stack, PluginConfig.CLIENT);
                if (name == null) continue;
                tooltip.add((Component)IWailaConfig.get().getFormatter().modName(name));
                return;
            }
        }
    }

    protected static void onServerLogIn(Connection connection) {
        Waila.BLACKLIST_CONFIG.invalidate();
        PluginConfig.getSyncableConfigs().forEach(config -> config.setServerValue(null));
    }

    protected static void onServerLogout(Connection connection) {
        Waila.BLACKLIST_CONFIG.invalidate();
        PluginConfig.getSyncableConfigs().forEach(config -> config.setServerValue(null));
    }

    private static KeyMapping createKeyBind(String id) {
        return IClientService.INSTANCE.createKeyBind(id, InputConstants.f_84822_.m_84873_());
    }
}

