/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.foundation.data.advancement;

import com.google.gson.JsonObject;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.utility.Components;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.foundation.data.advancement.CeiAdvancements;
import plus.dragons.createenchantmentindustry.foundation.data.advancement.CeiTriggers;
import plus.dragons.createenchantmentindustry.foundation.data.advancement.ModdedCreateAdvancement;
import plus.dragons.createenchantmentindustry.foundation.data.advancement.SimpleTrigger;
import plus.dragons.createenchantmentindustry.foundation.mixin.CreateAdvancementConstructor;

public class CeiAdvancement {
    protected final ResourceLocation id;
    protected final Advancement.Builder builder;
    @Nullable
    protected final SimpleTrigger builtinTrigger;
    protected final String titleKey;
    protected final String descriptionKey;
    protected final String title;
    protected final String description;
    @Nullable
    protected final CeiAdvancement parent;
    @Nullable
    protected final CreateAdvancement createAdvancement;
    protected Advancement advancement;

    protected CeiAdvancement(String id, Advancement.Builder builder, @Nullable CeiAdvancement parent, boolean builtin, String title, String description) {
        this.id = EnchantmentIndustry.genRL(id);
        this.builder = builder;
        this.parent = parent;
        if (builtin) {
            this.builtinTrigger = CeiTriggers.addSimple("builtin/" + id);
            this.builder.m_138386_("builtin", (CriterionTriggerInstance)this.builtinTrigger.instance());
        } else {
            this.builtinTrigger = null;
        }
        this.createAdvancement = CreateAdvancementConstructor.createInstance(id, $ -> $);
        ((ModdedCreateAdvancement)this.createAdvancement).fromModAdvancement(this);
        this.titleKey = new StringJoiner(".").add("advancement").add("create_enchantment_industry").add(id).toString();
        this.descriptionKey = this.titleKey + ".desc";
        this.title = title;
        this.description = description;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public String titleKey() {
        return this.titleKey;
    }

    public String descriptionKey() {
        return this.descriptionKey;
    }

    public String title() {
        return this.title;
    }

    public String description() {
        return this.description;
    }

    @Nullable
    public SimpleTrigger getTrigger() {
        return this.builtinTrigger;
    }

    public CreateAdvancement asCreateAdvancement() {
        if (this.createAdvancement == null) {
            throw new UnsupportedOperationException("Advancement [" + this.id + "] can not convert into CreateAdvancement!");
        }
        return this.createAdvancement;
    }

    public boolean isAlreadyAwardedTo(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer sp = (ServerPlayer)player;
        Advancement advancement = sp.m_20194_().m_129889_().m_136041_(this.id);
        if (advancement == null) {
            return true;
        }
        return sp.m_8960_().m_135996_(advancement).m_8193_();
    }

    public void awardTo(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (this.builtinTrigger == null) {
            throw new UnsupportedOperationException("Advancement [" + this.id + "] uses external Triggers, it cannot be awarded directly");
        }
        this.builtinTrigger.trigger(sp);
    }

    public void save(Consumer<Advancement> consumer) {
        if (this.parent != null) {
            this.builder.m_138398_(this.parent.advancement);
        }
        this.advancement = this.builder.m_138389_(consumer, this.id.toString());
    }

    public void appendToLang(JsonObject object) {
        object.addProperty(this.titleKey(), this.title());
        object.addProperty(this.descriptionKey(), this.description());
    }

    protected static class Builder {
        @Nullable
        private final ResourceLocation background;
        private final String id;
        private final Advancement.Builder builder = Advancement.Builder.m_138353_();
        @Nullable
        private CeiAdvancement parent;
        private boolean builtin = true;
        private String title = "Untitled";
        private String description = "No Description";
        private ItemStack icon = ItemStack.f_41583_;
        private FrameType frame = FrameType.TASK;
        private boolean toast = true;
        private boolean announce = false;
        private boolean hide = false;

        protected Builder(String id) {
            this.id = id;
            this.background = "root".equals(id) ? EnchantmentIndustry.genRL("textures/gui/advancements.png") : null;
        }

        protected Builder title(String title) {
            this.title = title;
            return this;
        }

        protected Builder description(String description) {
            this.description = description;
            return this;
        }

        protected Builder icon(ItemStack stack) {
            this.icon = stack;
            return this;
        }

        protected Builder icon(ItemProviderEntry<?> item) {
            return this.icon(item.asStack());
        }

        protected Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        protected Builder frame(FrameType frame) {
            this.frame = frame;
            return this;
        }

        protected Builder toast(boolean bl) {
            this.toast = bl;
            return this;
        }

        protected Builder announce(boolean bl) {
            this.announce = bl;
            return this;
        }

        protected Builder hidden() {
            this.hide = true;
            return this;
        }

        protected Builder externalTrigger(String key, CriterionTriggerInstance trigger) {
            this.builder.m_138386_(key, trigger);
            this.builtin = false;
            return this;
        }

        protected Builder parent(ResourceLocation id) {
            this.builder.m_138398_(new Advancement(id, null, null, AdvancementRewards.f_9978_, Map.of(), new String[0][0]));
            return this;
        }

        protected Builder parent(CeiAdvancement advancement) {
            this.parent = advancement;
            return this;
        }

        protected Builder transform(NonNullUnaryOperator<Advancement.Builder> transform) {
            transform.apply((Object)this.builder);
            return this;
        }

        protected CeiAdvancement build() {
            if (this.hide) {
                this.description = this.description + "\u00a77\n(Hidden Advancement)";
            }
            CeiAdvancement advancement = new CeiAdvancement(this.id, this.builder, this.parent, this.builtin, this.title, this.description);
            this.builder.m_138362_(this.icon, (Component)Components.translatable((String)advancement.titleKey), (Component)Components.translatable((String)advancement.descriptionKey).m_130938_(s -> s.m_178520_(14393875)), this.background, this.frame, this.toast, this.announce, this.hide);
            CeiAdvancements.ENTRIES.add(advancement);
            return advancement;
        }
    }
}

