/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import dev.murad.shipping.entity.custom.vessel.SpringEntity;
import dev.murad.shipping.entity.custom.vessel.barge.AbstractBargeEntity;
import dev.murad.shipping.entity.custom.vessel.tug.VehicleFrontPart;
import dev.murad.shipping.util.LinkableEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntitySpringAPI {
    private static final BiFunction<Entity, SpringEntity.SpringSide, Vec3> DEFAULT_ANCHOR_LOCATION = (e, sideArg) -> e.m_20182_();
    private static final List<Predicate<Entity>> predicates = new ArrayList<Predicate<Entity>>();
    private static final Map<Class<? extends Entity>, BiFunction<Entity, SpringEntity.SpringSide, Vec3>> mapping = new HashMap<Class<? extends Entity>, BiFunction<Entity, SpringEntity.SpringSide, Vec3>>();
    public static final BiFunction<Entity, SpringEntity.SpringSide, Vec3> DEFAULT_BOAT_ANCHOR = (entity, side) -> {
        float distanceFromCenter = 1.0625f * (side == SpringEntity.SpringSide.DOMINANT ? 1.0f : -1.0f);
        double anchorX = entity.m_20185_() + Math.cos((float)((double)(entity.m_146908_() + 90.0f) * Math.PI / 180.0)) * (double)distanceFromCenter;
        double anchorY = entity.m_20186_();
        double anchorZ = entity.m_20189_() + Math.sin((float)((double)(entity.m_146908_() + 90.0f) * Math.PI / 180.0)) * (double)distanceFromCenter;
        return new Vec3(anchorX, anchorY, anchorZ);
    };

    private EntitySpringAPI() {
    }

    public static boolean isValidTarget(Entity target) {
        return target instanceof LinkableEntity || target instanceof VehicleFrontPart;
    }

    public static void addGenericAnchorMapping(Class<? extends Entity> entity, BiFunction<Entity, SpringEntity.SpringSide, Vec3> function) {
        mapping.put(entity, function);
    }

    public static <T extends Entity> void addAnchorMapping(Class<? extends T> entity, BiFunction<T, SpringEntity.SpringSide, Vec3> function) {
        mapping.put(entity, (e, side) -> (Vec3)function.apply((Object)e, (SpringEntity.SpringSide)((Object)side)));
    }

    public static Vec3 calculateAnchorPosition(Entity entity, SpringEntity.SpringSide side) {
        BiFunction<Entity, SpringEntity.SpringSide, Vec3> function = mapping.getOrDefault(entity.getClass(), DEFAULT_ANCHOR_LOCATION);
        return function.apply(entity, side);
    }

    static {
        EntitySpringAPI.addGenericAnchorMapping(AbstractBargeEntity.class, DEFAULT_BOAT_ANCHOR);
    }
}

