/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.energy;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.block.IVesselLoader;
import dev.murad.shipping.block.energy.VesselChargerBlock;
import dev.murad.shipping.capability.ReadWriteEnergyStorage;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class VesselChargerTileEntity
extends BlockEntity
implements IVesselLoader {
    private static final int MAX_TRANSFER = (Integer)ShippingConfig.Server.VESSEL_CHARGER_BASE_MAX_TRANSFER.get();
    private static final int MAX_CAPACITY = (Integer)ShippingConfig.Server.VESSEL_CHARGER_BASE_CAPACITY.get();
    private final ReadWriteEnergyStorage internalBattery = new ReadWriteEnergyStorage(MAX_CAPACITY, MAX_TRANSFER, MAX_TRANSFER);
    private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this.internalBattery);
    private int cooldownTime = 0;

    public VesselChargerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntitiesTypes.VESSEL_CHARGER.get(), pos, state);
        this.internalBattery.setEnergy(0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    private void serverTickInternal() {
        if (this.f_58857_ != null) {
            --this.cooldownTime;
            if (this.cooldownTime <= 0) {
                this.cooldownTime = this.tryChargeEntity() ? 0 : 10;
            }
        }
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, VesselChargerTileEntity e) {
        e.serverTickInternal();
    }

    private boolean tryChargeEntity() {
        return IVesselLoader.getEntityCapability(this.m_58899_().m_142300_((Direction)this.m_58900_().m_61143_((Property)VesselChargerBlock.FACING)), CapabilityEnergy.ENERGY, this.f_58857_).map(iEnergyStorage -> {
            int vesselCap = iEnergyStorage.receiveEnergy(MAX_TRANSFER, true);
            int toTransfer = this.internalBattery.extractEnergy(vesselCap, false);
            return iEnergyStorage.receiveEnergy(toTransfer, false) > 0;
        }).orElse(false);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.internalBattery.readAdditionalSaveData(compound.m_128469_("energy_storage"));
    }

    public void m_183515_(CompoundTag compound) {
        CompoundTag energyNBT = new CompoundTag();
        this.internalBattery.addAdditionalSaveData(energyNBT);
        super.m_183515_(compound);
        compound.m_128365_("energy_storage", (Tag)energyNBT);
    }

    @Override
    public <T extends Entity> boolean hold(T vehicle, IVesselLoader.Mode mode) {
        return vehicle.getCapability(CapabilityEnergy.ENERGY).map(energyHandler -> {
            switch (mode) {
                case EXPORT: {
                    return energyHandler.getEnergyStored() < energyHandler.getMaxEnergyStored() - 50 && this.internalBattery.getEnergyStored() > 50;
                }
            }
            return false;
        }).orElse(false);
    }

    public void use(Player player, InteractionHand hand) {
        player.m_5661_((Component)new TranslatableComponent("block.littlelogistics.vessel_charger.capacity", new Object[]{this.internalBattery.getEnergyStored(), this.internalBattery.getMaxEnergyStored()}), false);
    }
}

