/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createendertransmission.blocks.energyTransmitter;

import com.forsteri.createendertransmission.blocks.energyTransmitter.EnergyNetwork;
import com.forsteri.createendertransmission.transmitUtil.ITransmitter;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EnergyTransmitterBlockEntity
extends KineticBlockEntity
implements ITransmitter {
    public EnergyTransmitterBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean isCustomConnection(KineticBlockEntity other, BlockState state, BlockState otherState) {
        if (other instanceof EnergyTransmitterBlockEntity) {
            EnergyTransmitterBlockEntity otherTransmitter = (EnergyTransmitterBlockEntity)other;
            return otherTransmitter.getChannel() == this.getChannel() && otherTransmitter.m_58904_() == this.m_58904_() && otherTransmitter.getPassword().equals(this.getPassword());
        }
        return false;
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        ArrayList<KineticBlockEntity> checks = new ArrayList<KineticBlockEntity>(this.getConnectedTransmitters());
        for (KineticBlockEntity tile : checks) {
            if (tile.m_58899_() == this.m_58899_() || neighbours.contains(tile.m_58899_())) continue;
            neighbours.add(tile.m_58899_());
        }
        return super.addPropagationLocations(block, state, neighbours);
    }

    public List<KineticBlockEntity> getConnectedTransmitters() {
        Map<String, List<KineticBlockEntity>> channel = EnergyNetwork.ENERGY.channels.get(this.getChannel());
        channel.values().removeIf(List::isEmpty);
        channel.forEach((password, transmitters) -> transmitters.removeIf(blockEntity -> {
            EnergyTransmitterBlockEntity transmitter;
            return !(blockEntity instanceof EnergyTransmitterBlockEntity) || (transmitter = (EnergyTransmitterBlockEntity)blockEntity).getChannel() != this.getChannel() || !transmitter.getPassword().equals(password);
        }));
        channel.values().forEach(list -> list.removeIf(BlockEntity::m_58901_));
        if (channel.containsKey(this.getPassword())) {
            List<KineticBlockEntity> list2 = channel.get(this.getPassword());
            if (!list2.contains(this)) {
                list2.add(this);
            }
            return list2;
        }
        ArrayList<KineticBlockEntity> list3 = new ArrayList<KineticBlockEntity>(List.of(this));
        channel.put(this.getTileData().m_128461_("password"), list3);
        return list3;
    }

    @Override
    public void reloadSettings() {
        this.getConnectedTransmitters().remove(this);
        if (this.f_58857_ == null) {
            return;
        }
        if (this.hasNetwork()) {
            this.getOrCreateNetwork().remove((KineticBlockEntity)this);
        }
        this.detachKinetics();
        this.removeSource();
    }

    @Override
    public void afterReload() {
        if (this.f_58857_ == null) {
            return;
        }
        this.attachKinetics();
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        return target.getTileData().m_128451_("channel") == this.getTileData().m_128451_("channel") && target.getTileData().m_128461_("password").equals(this.getTileData().m_128461_("password")) ? 1.0f : 0.0f;
    }
}

