/*
 * Decompiled with CFR 0.152.
 */
package github.shrekshellraiser.cctech.common.peripheral.tape.reel;

import dan200.computercraft.api.lua.LuaException;
import github.shrekshellraiser.cctech.common.ModBlockEntities;
import github.shrekshellraiser.cctech.common.ModProperties;
import github.shrekshellraiser.cctech.common.config.CCTechCommonConfigs;
import github.shrekshellraiser.cctech.common.item.tape.ReelItem;
import github.shrekshellraiser.cctech.common.peripheral.tape.TapeBlockEntity;
import github.shrekshellraiser.cctech.common.peripheral.tape.reel.ReelToReelPeripheral;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ReelToReelBlockEntity
extends TapeBlockEntity {
    protected boolean isLocked;

    @Override
    public void assertReady() throws LuaException {
        BlockState state = this.m_58900_();
        if (((Boolean)state.m_61143_((Property)ModProperties.OPEN)).booleanValue()) {
            throw new LuaException("Door open");
        }
        if (!((Boolean)state.m_61143_((Property)ModProperties.LOCKED)).booleanValue()) {
            throw new LuaException("Door unlocked");
        }
        super.assertReady();
    }

    @Override
    protected void itemRemoved(ItemStack item) {
        this.pointer = 0;
        super.itemRemoved(item);
    }

    @Override
    protected void itemInserted(ItemStack item) {
        super.itemInserted(item);
        this.pointer = 0;
    }

    public ReelToReelBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.REEL_TO_REEL.get(), pWorldPosition, pBlockState);
        this.deviceDir = ReelItem.getDeviceDir();
        this.peripheral = new ReelToReelPeripheral(this);
        this.ticksPerByte = 1.0 / ((double)((Integer)CCTechCommonConfigs.REEL_BYTES_PER_SECOND.get()).intValue() / 20.0);
    }

    public boolean setLock(boolean state) throws LuaException {
        if (((Boolean)this.m_58900_().m_61143_((Property)ModProperties.OPEN)).booleanValue()) {
            throw new LuaException("Door open");
        }
        this.isLocked = state;
        return this.isLocked;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128379_("locked", this.isLocked);
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isLocked = nbt.m_128471_("locked");
    }

    @Override
    public void drops() {
        this.pointer = 0;
        super.drops();
    }

    public int getPointer() {
        return this.pointer;
    }

    public void onRightClick(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (pPlayer.m_21205_().m_41720_() instanceof ReelItem && this.getItem() == Items.f_41852_) {
            this.itemHandler.setStackInSlot(0, pPlayer.m_21205_());
            pPlayer.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41852_));
        } else if (pPlayer.m_21205_().m_41720_() == Items.f_41852_) {
            pPlayer.m_8061_(EquipmentSlot.MAINHAND, this.itemHandler.getStackInSlot(0));
            this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_41852_));
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, ReelToReelBlockEntity pBlockEntity) {
        TapeBlockEntity.tick(pLevel, pPos, pState, pBlockEntity);
        if (!pLevel.m_5776_() && (Boolean)pState.m_61143_((Property)ModProperties.LOCKED) != pBlockEntity.isLocked) {
            pState = (BlockState)pState.m_61124_((Property)ModProperties.LOCKED, (Comparable)Boolean.valueOf(pBlockEntity.isLocked));
            pLevel.m_7731_(pPos, pState, 3);
            pLevel.m_151543_(pPos);
            pLevel.m_46717_(pPos, pState.m_60734_());
        }
    }
}

