/*
 * Decompiled with CFR 0.152.
 */
package github.shrekshellraiser.cctech.common.peripheral.tape;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import github.shrekshellraiser.cctech.common.item.tape.TapeItem;
import github.shrekshellraiser.cctech.common.peripheral.tape.TapeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public abstract class TapePeripheral
implements IPeripheral {
    private final List<IComputerAccess> connectedComputers = new ArrayList<IComputerAccess>();
    protected final TapeBlockEntity tileEntity;

    public TapePeripheral(TapeBlockEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.connectedComputers.remove(computer);
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.connectedComputers.add(computer);
    }

    @LuaFunction
    public boolean isReady() {
        return this.tileEntity.getItem() instanceof TapeItem;
    }

    @LuaFunction
    public final MethodResult read(IComputerAccess computerAccess, Optional<Integer> targetChars, Optional<Boolean> async) throws LuaException {
        int characters = targetChars.orElse(1);
        if (characters < 1) {
            throw new LuaException("Cannot read <1 bytes.");
        }
        return this.tileEntity.readData(computerAccess, characters, async.orElse(false));
    }

    @LuaFunction
    public final MethodResult write(IComputerAccess computerAccess, String ch, Optional<Boolean> async) throws LuaException {
        return this.tileEntity.write(computerAccess, ch, async.orElse(false));
    }

    @LuaFunction
    public final MethodResult seek(IComputerAccess computerAccess, int offset, Optional<Boolean> async) throws LuaException {
        return this.tileEntity.seekRel(computerAccess, offset, async.orElse(false));
    }

    @LuaFunction
    public final void setLabel(String label) throws LuaException {
        this.tileEntity.setLabel(label);
    }

    @LuaFunction
    public final void clearLabel() throws LuaException {
        this.tileEntity.clearLabel();
    }

    @LuaFunction
    public final int getSize() throws LuaException {
        return this.tileEntity.getSize();
    }
}

