/*
 * Decompiled with CFR 0.152.
 */
package github.shrekshellraiser.cctech.common.item.tape;

import github.shrekshellraiser.cctech.CCTech;
import github.shrekshellraiser.cctech.common.config.CCTechCommonConfigs;
import github.shrekshellraiser.cctech.common.item.ModItems;
import github.shrekshellraiser.cctech.common.item.StorageItem;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TapeItem
extends StorageItem {
    protected int defaultLength;
    protected int maxLength;
    public static final String LengthTag = "cctech.length";

    public TapeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (Screen.m_96638_()) {
            int curLength = ((TapeItem)pStack.m_41720_()).getLength(pStack);
            int maxLength = ((TapeItem)pStack.m_41720_()).maxLength;
            String dataLength = curLength + " / " + maxLength + " bytes";
            pTooltipComponents.add((Component)new TextComponent(dataLength));
            String audioLength = curLength / 6000 + " / " + maxLength / 6000 + " seconds";
            pTooltipComponents.add((Component)new TextComponent(audioLength));
        }
    }

    @Override
    public int getSize(ItemStack item) {
        return this.getLength(item);
    }

    public int getLength(ItemStack stack) {
        int length = this.defaultLength;
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            if (tag.m_128441_(LengthTag)) {
                length = tag.m_128451_(LengthTag);
            } else {
                tag.m_128405_(LengthTag, length);
                stack.m_41751_(tag);
            }
        } else {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_(LengthTag, length);
            stack.m_41751_(tag);
        }
        return length;
    }

    public boolean setLength(ItemStack stack, int length) {
        CCTech.LOGGER.debug("Target length " + length);
        length = Math.min(length, this.maxLength);
        int oldLength = this.getLength(stack);
        length = Math.max(oldLength, length);
        CompoundTag tag = stack.m_41783_();
        tag.m_128405_(LengthTag, length);
        stack.m_41751_(tag);
        return length != oldLength;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack pStack = pPlayer.m_21120_(pHand);
        if (!pLevel.m_5776_()) {
            Inventory inventory = pPlayer.m_150109_();
            int slot = inventory.m_36030_(new ItemStack((ItemLike)ModItems.TAPE.get()));
            if (slot == -1 && !pPlayer.m_7500_()) {
                return InteractionResultHolder.m_19100_((Object)pStack);
            }
            TapeItem item = (TapeItem)pStack.m_41720_();
            if (item.setLength(pStack, item.getLength(pStack) + (Integer)CCTechCommonConfigs.TAPE_SIZE.get())) {
                if (!pPlayer.m_7500_()) {
                    inventory.m_7407_(slot, 1);
                }
                return InteractionResultHolder.m_19090_((Object)pStack);
            }
        }
        return InteractionResultHolder.m_19100_((Object)pStack);
    }
}

