/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.justzoom;

import de.keksuccino.justzoom.JustZoom;
import de.keksuccino.justzoom.KeyBindings;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZoomHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Minecraft MC = Minecraft.m_91087_();
    public static boolean isZoomed = false;
    public static double zoomFactor = (Double)JustZoom.getConfig().getOrDefault("base_zoom_factor", (Object)0.25);
    public static double lerpAmount = (Double)JustZoom.getConfig().getOrDefault("lerp_amount", (Object)0.1);
    private static double cachedFov;
    private static double cachedDefaultFov;
    private static boolean cachedSmoothCamera;
    private static boolean lastFov;

    public static void init() {
        KeyBindings.init();
        MinecraftForge.EVENT_BUS.register((Object)new ZoomHandler());
    }

    public static double handleZoom(double fov) {
        cachedDefaultFov = fov;
        if (KeyBindings.keyToggleZoom.m_90857_()) {
            if (((Boolean)JustZoom.getConfig().getOrDefault("smooth_camera_on_zoom", (Object)true)).booleanValue()) {
                if (!isZoomed) {
                    cachedSmoothCamera = ZoomHandler.MC.f_91066_.f_92067_;
                }
                ZoomHandler.MC.f_91066_.f_92067_ = true;
            }
            isZoomed = true;
            double modifiedZoom = fov * zoomFactor;
            if (modifiedZoom < 1.0) {
                modifiedZoom = 1.0;
            }
            if (modifiedZoom > 170.0) {
                modifiedZoom = 170.0;
            }
            if ((cachedFov += (modifiedZoom - cachedFov) * lerpAmount) > cachedDefaultFov) {
                cachedFov = cachedDefaultFov;
            }
            return cachedFov;
        }
        if (isZoomed) {
            if (!lastFov) {
                cachedFov += (cachedDefaultFov - cachedFov) * lerpAmount;
            }
            if ((Math.abs(cachedFov - cachedDefaultFov) < 1.0 || cachedFov - cachedDefaultFov >= 0.0) && !lastFov) {
                if (cachedFov < cachedDefaultFov) {
                    cachedFov += 1.0;
                }
                lastFov = true;
            }
            if (lastFov) {
                cachedFov = cachedDefaultFov;
                if (((Boolean)JustZoom.getConfig().getOrDefault("smooth_camera_on_zoom", (Object)true)).booleanValue()) {
                    ZoomHandler.MC.f_91066_.f_92067_ = cachedSmoothCamera;
                }
                isZoomed = false;
                if (((Boolean)JustZoom.getConfig().getOrDefault("reset_zoom_factor", (Object)true)).booleanValue()) {
                    zoomFactor = (Double)JustZoom.getConfig().getOrDefault("base_zoom_factor", (Object)0.25);
                }
                lastFov = false;
            }
            return cachedFov;
        }
        cachedFov = fov;
        return fov;
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollEvent e) {
        if (KeyBindings.keyToggleZoom.m_90857_()) {
            e.setCanceled(true);
            if (e.getScrollDelta() < 0.0) {
                if (cachedFov < 170.0) {
                    if (((Boolean)JustZoom.getConfig().getOrDefault("zoom_out_cap", (Object)true)).booleanValue() && cachedFov >= cachedDefaultFov) {
                        return;
                    }
                    zoomFactor += ((Double)JustZoom.getConfig().getOrDefault("zoom_out_per_scroll", (Object)0.05)).doubleValue();
                }
            } else if (e.getScrollDelta() > 0.0 && cachedFov > 1.0 && (zoomFactor -= ((Double)JustZoom.getConfig().getOrDefault("zoom_in_per_scroll", (Object)0.05)).doubleValue()) < 0.0) {
                zoomFactor = 0.0;
            }
        }
    }

    static {
        lastFov = false;
    }
}

