/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.survey;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.common.util.survey.ISurveyInfo;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class IslandInfo
implements ISurveyInfo {
    public static final String TAG_KEY = "islandscan";
    private int x;
    private int z;
    private byte status;
    private long amount;
    private FluidStack fluidStack = FluidStack.EMPTY;
    private int expected;

    public IslandInfo(CompoundTag tag) {
        this.x = tag.m_128451_("x");
        this.z = tag.m_128451_("z");
        this.status = tag.m_128445_("status");
        this.amount = tag.m_128454_("amount");
        this.expected = tag.m_128451_("expected");
        if (tag.m_128441_("fluid")) {
            try {
                ResourceLocation fluidRL = new ResourceLocation(tag.m_128461_("fluid"));
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidRL);
                if (fluid != null) {
                    this.fluidStack = new FluidStack(fluid, 1);
                }
            }
            catch (ResourceLocationException e) {
                ImmersivePetroleum.log.debug("IslandInfo invalid ResourceLocation. Ignoring.");
            }
        }
    }

    public IslandInfo(Level world, BlockPos pos, ReservoirIsland island) {
        this.x = pos.m_123341_();
        this.z = pos.m_123343_();
        this.status = (byte)((float)island.getAmount() / (float)island.getCapacity() * 100.0f);
        this.amount = island.getAmount();
        this.fluidStack = new FluidStack(island.getFluid(), 1);
        this.expected = ReservoirIsland.getFlow(island.getPressure(world, pos.m_123341_(), pos.m_123343_()));
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public byte getStatus() {
        return this.status;
    }

    public int getExpected() {
        return this.expected;
    }

    public long getAmount() {
        return this.amount;
    }

    @Nonnull
    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public Fluid getFluid() {
        return this.fluidStack.getFluid();
    }

    @Override
    public CompoundTag writeToStack(ItemStack stack) {
        return this.writeToTag(stack.m_41698_(TAG_KEY));
    }

    @Override
    public CompoundTag writeToTag(CompoundTag tag) {
        tag.m_128405_("x", this.x);
        tag.m_128405_("z", this.z);
        tag.m_128344_("status", this.status);
        tag.m_128356_("amount", this.amount);
        tag.m_128405_("expected", this.expected);
        if (!this.fluidStack.isEmpty()) {
            tag.m_128359_("fluid", this.fluidStack.getFluid().getRegistryName().toString());
        }
        return tag;
    }
}

