/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import flaxbeard.immersivepetroleum.api.crafting.HighPressureRefineryRecipe;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.compat.jei.IPRecipeCategory;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HighPressureRefineryRecipeCategory
extends IPRecipeCategory<HighPressureRefineryRecipe> {
    public static final ResourceLocation ID = ResourceUtils.ip("hydrotreater");
    private final IDrawableStatic tankOverlay;

    public HighPressureRefineryRecipeCategory(IGuiHelper guiHelper) {
        super(HighPressureRefineryRecipe.class, guiHelper, ID, "block.immersivepetroleum.hydrotreater");
        ResourceLocation background = ResourceUtils.ip("textures/gui/jei/hydrotreater.png");
        this.setBackground(guiHelper.createDrawable(background, 0, 0, 113, 75));
        this.setIcon(new ItemStack((ItemLike)IPContent.Multiblock.HYDROTREATER.get()));
        this.tankOverlay = guiHelper.createDrawable(background, 113, 0, 20, 51);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HighPressureRefineryRecipe recipe, @Nonnull IFocusGroup focuses) {
        int primaryInputAmount = recipe.inputFluid.getAmount();
        int secondaryInputAmount = recipe.inputFluidSecondary != null ? recipe.inputFluidSecondary.getAmount() : 0;
        int outputAmount = recipe.output.getAmount();
        int guiTankSize = Math.min(Math.max(Math.max(primaryInputAmount, secondaryInputAmount), outputAmount), 1000);
        builder.addSlot(RecipeIngredientRole.INPUT, 25, 3).setFluidRenderer(guiTankSize, false, 20, 51).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.inputFluid.getMatchingFluidStacks());
        IRecipeSlotBuilder secondary = builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).setFluidRenderer(guiTankSize, false, 20, 51).setOverlay((IDrawable)this.tankOverlay, 0, 0);
        if (recipe.inputFluidSecondary != null) {
            secondary.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.inputFluidSecondary.getMatchingFluidStacks());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 71, 3).setFluidRenderer(guiTankSize, false, 20, 51).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.output);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 94, 21).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.outputItem);
    }

    public void draw(HighPressureRefineryRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, PoseStack matrix, double mouseX, double mouseY) {
        IDrawable background = this.getBackground();
        int bWidth = background.getWidth();
        int bHeight = background.getHeight();
        Font font = MCUtil.getFont();
        int time = recipe.getTotalProcessTime();
        int energy = recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime();
        int chance = (int)(100.0 * recipe.chance);
        matrix.m_85836_();
        String text0 = I18n.m_118938_((String)"desc.immersiveengineering.info.ift", (Object[])new Object[]{Utils.fDecimal(energy)});
        float f = bWidth / 2 - font.m_92895_(text0) / 2;
        Objects.requireNonNull(font);
        font.m_92883_(matrix, text0, f, (float)(bHeight - 9 * 2), 0);
        String text1 = I18n.m_118938_((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.fDecimal((double)time / 20.0)});
        float f2 = bWidth / 2 - font.m_92895_(text1) / 2;
        Objects.requireNonNull(font);
        font.m_92883_(matrix, text1, f2, (float)(bHeight - 9), 0);
        if (recipe.hasSecondaryItem()) {
            String text2 = String.format(Locale.US, "%d%%", chance);
            font.m_92883_(matrix, text2, (float)(bWidth + 3 - font.m_92895_(text2)), (float)(bHeight / 2 + 4), 0);
        }
        matrix.m_85849_();
    }

    @Deprecated
    public ResourceLocation getUid() {
        return null;
    }

    @Deprecated
    public Class<? extends HighPressureRefineryRecipe> getRecipeClass() {
        return null;
    }
}

