/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.common.network.INetMessage;
import flaxbeard.immersivepetroleum.common.network.MessageConsumeBoatFuel;
import flaxbeard.immersivepetroleum.common.network.MessageDebugSync;
import flaxbeard.immersivepetroleum.common.network.MessageDerrick;
import flaxbeard.immersivepetroleum.common.network.MessageProjectorSync;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class IPPacketHandler {
    public static final String NET_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ResourceUtils.ip("main")).networkProtocolVersion(() -> "1").serverAcceptedVersions("1"::equals).clientAcceptedVersions("1"::equals).simpleChannel();
    private static int id = 0;

    public static void preInit() {
        IPPacketHandler.registerMessage(MessageDebugSync.class, MessageDebugSync::new);
        IPPacketHandler.registerMessage(MessageConsumeBoatFuel.class, MessageConsumeBoatFuel::new);
        IPPacketHandler.registerMessage(MessageProjectorSync.class, MessageProjectorSync::new);
        IPPacketHandler.registerMessage(MessageDerrick.class, MessageDerrick::new);
    }

    public static <T extends INetMessage> void registerMessage(Class<T> type, Function<FriendlyByteBuf, T> decoder) {
        INSTANCE.registerMessage(id++, type, INetMessage::toBytes, decoder, (t, ctx) -> {
            t.process((Supplier<NetworkEvent.Context>)ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static <MSG> void sendToPlayer(Player player, @Nonnull MSG message) {
        if (message != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), message);
        }
    }

    public static <MSG> void sendToServer(MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.SERVER.noArg(), message);
    }

    public static <MSG> void sendToDimension(ResourceKey<Level> dim, MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> dim), message);
    }

    public static <MSG> void sendAll(MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }
}

