/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellPipeTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.multiblocks.PumpjackMultiblock;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class PumpjackTileEntity
extends PoweredMultiblockBlockEntity<PumpjackTileEntity, MultiblockRecipe>
implements IPCommonTickableTile,
IEBlockInterfaces.IBlockBounds {
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(0, 1, 5));
    public static final Set<PoweredMultiblockBlockEntity.MultiblockFace> Energy_IN = ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 1, 5, RelativeBlockFace.UP));
    public static final BlockPos East_Port = new BlockPos(2, 0, 2);
    public static final BlockPos West_Port = new BlockPos(0, 0, 2);
    public static final BlockPos Down_Port = new BlockPos(1, 0, 0);
    public static final FluidTank FAKE_TANK = new FluidTank(0);
    public boolean wasActive = false;
    public float activeTicks = 0.0f;
    private final ResettableCapability<IFluidHandler> fakeFluidHandler = this.registerFluidHandler(new IFluidTank[]{FAKE_TANK});
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(PumpjackTileEntity::getShape);

    public PumpjackTileEntity(BlockEntityType<PumpjackTileEntity> type, BlockPos pWorldPosition, BlockState pBlockState) {
        super((IETemplateMultiblock)PumpjackMultiblock.INSTANCE, 16000, true, type, pWorldPosition, pBlockState);
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        boolean lastActive = this.wasActive;
        this.wasActive = nbt.m_128471_("wasActive");
        if (!this.wasActive && lastActive) {
            this.activeTicks += 1.0f;
        }
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128379_("wasActive", this.wasActive);
    }

    @Override
    public void tickClient() {
        if (!this.isDummy() && this.wasActive) {
            this.activeTicks += 1.0f;
        }
    }

    @Override
    public void tickServer() {
        int consumption;
        int extracted;
        WellPipeTileEntity pipe;
        WellTileEntity well;
        BlockEntity teLow;
        if (this.isDummy()) {
            return;
        }
        super.tickServer();
        boolean active = false;
        if (!this.isRSDisabled() && (teLow = this.getLevelNonnull().m_7702_(this.f_58858_.m_7495_())) instanceof WellPipeTileEntity && (well = (pipe = (WellPipeTileEntity)teLow).getWell()) != null && (extracted = this.energyStorage.extractEnergy(consumption = ((Integer)IPServerConfig.EXTRACTION.pumpjack_consumption.get()).intValue(), true)) >= consumption) {
            boolean foundPressurizedIsland = false;
            for (ColumnPos cPos : well.tappedIslands) {
                ReservoirIsland island = ReservoirHandler.getIsland(this.f_58857_, cPos);
                if (island == null || !(island.getPressure(this.getLevelNonnull(), cPos.f_140723_, cPos.f_140724_) > 0.0f)) continue;
                foundPressurizedIsland = true;
                break;
            }
            if (!foundPressurizedIsland) {
                int extractSpeed = (Integer)IPServerConfig.EXTRACTION.pumpjack_speed.get();
                Direction portEast_facing = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
                Direction portWest_facing = this.getIsMirrored() ? this.getFacing().m_122427_() : this.getFacing().m_122428_();
                BlockPos portEast_pos = this.getBlockPosForPos(East_Port).m_142300_(portEast_facing);
                BlockPos portWest_pos = this.getBlockPosForPos(West_Port).m_142300_(portWest_facing);
                IFluidHandler portEast_output = (IFluidHandler)FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)portEast_pos, (Direction)portEast_facing.m_122424_()).orElse(null);
                IFluidHandler portWest_output = (IFluidHandler)FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)portWest_pos, (Direction)portWest_facing.m_122424_()).orElse(null);
                for (ColumnPos cPos : well.tappedIslands) {
                    int drained;
                    int accepted;
                    ReservoirIsland island = ReservoirHandler.getIsland(this.f_58857_, cPos);
                    if (island == null) continue;
                    FluidStack fluid = new FluidStack(island.getFluid(), island.extract(extractSpeed, IFluidHandler.FluidAction.SIMULATE));
                    if (portEast_output != null && (accepted = portEast_output.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                        drained = portEast_output.fill(FluidHelper.copyFluid(fluid, Math.min(fluid.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
                        island.extract(drained, IFluidHandler.FluidAction.EXECUTE);
                        fluid = FluidHelper.copyFluid(fluid, fluid.getAmount() - drained);
                        active = true;
                    }
                    if (portWest_output == null || fluid.getAmount() <= 0 || (accepted = portWest_output.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                    drained = portWest_output.fill(FluidHelper.copyFluid(fluid, Math.min(fluid.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
                    island.extract(drained, IFluidHandler.FluidAction.EXECUTE);
                    active = true;
                }
                if (active) {
                    this.energyStorage.extractEnergy(consumption, false);
                    this.activeTicks += 1.0f;
                }
            }
        }
        if (active != this.wasActive) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
        this.wasActive = active;
    }

    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return Energy_IN;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(MultiblockProcess<MultiblockRecipe> process) {
    }

    public boolean additionalCanProcessCheck(MultiblockProcess<MultiblockRecipe> process) {
        return false;
    }

    public float getMinProcessDistance(MultiblockProcess<MultiblockRecipe> process) {
        return 0.0f;
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public int[] getOutputSlots() {
        return null;
    }

    public int[] getOutputTanks() {
        return new int[]{1};
    }

    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    protected MultiblockRecipe getRecipeForId(Level level, ResourceLocation id) {
        return null;
    }

    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.posInMultiblock.equals((Object)East_Port) && (side == null || (this.getIsMirrored() ? side == this.getFacing().m_122428_() : side == this.getFacing().m_122427_()))) {
                return this.fakeFluidHandler.cast();
            }
            if (this.posInMultiblock.equals((Object)West_Port) && (side == null || (this.getIsMirrored() ? side == this.getFacing().m_122427_() : side == this.getFacing().m_122428_()))) {
                return this.fakeFluidHandler.cast();
            }
        }
        return super.getCapability(capability, side);
    }

    @Nonnull
    public VoxelShape getBlockBounds(CollisionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        int bX = posInMultiblock.m_123341_();
        int bY = posInMultiblock.m_123342_();
        int bZ = posInMultiblock.m_123343_();
        if (bY == 3 && bX == 1 && bZ != 2 || bX == 1 && bY == 2 && bZ == 0) {
            return new ArrayList<AABB>();
        }
        if (bY < 3 && bX == 1 && bZ == 4) {
            ArrayList<AABB> list = new ArrayList<AABB>();
            if (bY == 2) {
                list.add(new AABB(0.25, 0.0, 0.0, 0.75, 0.25, 1.0));
            } else {
                list.add(new AABB(0.25, 0.0, 0.0, 0.75, 1.0, 1.0));
            }
            if (bY == 0) {
                list.add(new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
            }
            return list;
        }
        if (bZ == 2 && bY > 0) {
            if (bX == 0) {
                if (bY == 1) {
                    ArrayList<AABB> list = new ArrayList<AABB>();
                    list.add(new AABB(0.6875, 0.0, 0.0, 1.0, 1.0, 0.25));
                    list.add(new AABB(0.6875, 0.0, 0.75, 1.0, 1.0, 1.0));
                    return list;
                }
                if (bY == 2) {
                    ArrayList<AABB> list = new ArrayList<AABB>();
                    list.add(new AABB(0.8125, 0.0, 0.0, 1.0, 0.5, 1.0));
                    list.add(new AABB(0.8125, 0.5, 0.25, 1.0, 1.0, 0.75));
                    return list;
                }
                if (bY == 3) {
                    return List.of(new AABB(0.9375, 0.0, 0.375, 1.0, 0.125, 0.625));
                }
            }
            if (bX == 1 && bY == 3) {
                return List.of(new AABB(0.0, -0.125, 0.375, 1.0, 0.125, 0.625));
            }
            if (bX == 2) {
                if (bY == 1) {
                    ArrayList<AABB> list = new ArrayList<AABB>();
                    list.add(new AABB(0.0, 0.0, 0.0, 0.3125, 1.0, 0.25));
                    list.add(new AABB(0.0, 0.0, 0.75, 0.3125, 1.0, 1.0));
                    return list;
                }
                if (bY == 2) {
                    ArrayList<AABB> list = new ArrayList<AABB>();
                    list.add(new AABB(0.0, 0.0, 0.0, 0.1875, 0.5, 1.0));
                    list.add(new AABB(0.0, 0.5, 0.25, 0.1875, 1.0, 0.75));
                    return list;
                }
                if (bY == 3) {
                    return List.of(new AABB(0.0, 0.0, 0.375, 0.0625, 0.125, 0.625));
                }
            }
        }
        if (bX == 0 && bZ == 5) {
            if (bY == 0) {
                return Arrays.asList(new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AABB(0.75, 0.0, 0.625, 0.875, 1.0, 0.875), new AABB(0.125, 0.0, 0.625, 0.25, 1.0, 0.875));
            }
            if (bY == 1) {
                return List.of(new AABB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
            }
        }
        if (bX == 2 && bY == 0 && bZ == 5) {
            return List.of(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        if (bY == 0) {
            if (bZ == 1 && (bX == 0 || bX == 2)) {
                ArrayList<AABB> list = new ArrayList<AABB>();
                list.add(new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
                if (bX == 0) {
                    list.add(new AABB(0.5, 0.5, 0.5, 1.0, 1.0, 1.0));
                }
                if (bX == 2) {
                    list.add(new AABB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0));
                }
                return list;
            }
            if (bZ == 3 && (bX == 0 || bX == 2)) {
                ArrayList<AABB> list = new ArrayList<AABB>();
                list.add(new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
                if (bX == 0) {
                    list.add(new AABB(0.5, 0.5, 0.0, 1.0, 1.0, 0.5));
                }
                if (bX == 2) {
                    list.add(new AABB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5));
                }
                return list;
            }
            if (bZ == 2 && (bX == 0 || bX == 2)) {
                return List.of(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
            }
            if (bX == 1) {
                if (bZ == 0) {
                    return Arrays.asList(new AABB(0.3125, 0.5, 0.8125, 0.6875, 0.875, 1.0), new AABB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125));
                }
                if (bZ == 1) {
                    return Arrays.asList(new AABB(0.3125, 0.5, 0.0, 0.6875, 0.875, 1.0), new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
                }
                if (bZ == 2) {
                    return Arrays.asList(new AABB(0.3125, 0.5, 0.0, 0.6875, 0.875, 0.6875), new AABB(0.0, 0.5, 0.3125, 1.0, 0.875, 0.6875), new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
                }
            }
            return List.of(new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        return List.of(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }
}

