/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.DerrickTileEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class DerrickRenderer
implements BlockEntityRenderer<DerrickTileEntity> {
    static final ResourceLocation DERRICK_PIPE_RL = ResourceUtils.ip("multiblock/dyn/derrick_pipe");
    static final Function<ResourceLocation, BakedModel> f = rl -> MCUtil.getBlockRenderer().m_110907_().m_110881_().getModel(rl);
    static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f);

    public static void init() {
        ForgeModelBakery.addSpecialModel((ResourceLocation)DERRICK_PIPE_RL);
    }

    public boolean shouldRenderOffScreen(@Nonnull DerrickTileEntity te) {
        return true;
    }

    public void render(DerrickTileEntity te, float partialTicks, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.formed || te.isDummy() || !te.getLevelNonnull().m_46805_(te.m_58899_())) {
            return;
        }
        this.renderPipe(matrix, bufferIn, te, partialTicks, combinedLightIn, combinedOverlayIn);
    }

    private void renderPipe(PoseStack matrix, MultiBufferSource buffer, DerrickTileEntity te, float partialTicks, int light, int overlay) {
        matrix.m_85836_();
        float rot = (float)te.rotation + (te.drilling ? 9.0f * partialTicks : 0.0f);
        matrix.m_85837_(0.5, 0.0, 0.5);
        matrix.m_85845_(new Quaternion(Y_AXIS, rot, true));
        List quads = f.apply(DERRICK_PIPE_RL).getQuads(null, null, null, (IModelData)EmptyModelData.INSTANCE);
        PoseStack.Pose last = matrix.m_85850_();
        VertexConsumer solid = buffer.m_6299_(RenderType.m_110451_());
        for (BakedQuad quad : quads) {
            solid.m_85987_(last, quad, 1.0f, 1.0f, 1.0f, light, overlay);
        }
        matrix.m_85849_();
    }
}

