/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class LubricatedHandler {
    static final Map<Class<? extends BlockEntity>, ILubricationHandler<? extends BlockEntity>> lubricationHandlers = new HashMap<Class<? extends BlockEntity>, ILubricationHandler<? extends BlockEntity>>();
    public static List<LubricatedTileInfo> lubricatedTiles = new ArrayList<LubricatedTileInfo>();

    public static <T extends BlockEntity> void registerLubricatedTile(Class<T> tileClass, Supplier<ILubricationHandler<T>> handler) {
        ILubricationHandler<T> instance = handler.get();
        lubricationHandlers.put(tileClass, instance);
    }

    public static <T extends BlockEntity> ILubricationHandler<T> getHandlerForTile(T te) {
        Class<?> teClass;
        if (te != null && lubricationHandlers.containsKey(teClass = te.getClass())) {
            ILubricationHandler<? extends BlockEntity> tmp = lubricationHandlers.get(teClass);
            return tmp;
        }
        return null;
    }

    public static boolean lubricateTile(BlockEntity tile, Fluid lubricant, int ticks) {
        return LubricatedHandler.lubricateTile(tile, lubricant, ticks, false, -1);
    }

    public static boolean lubricateTile(BlockEntity tile, Fluid lubricant, int ticks, boolean additive, int cap) {
        if (tile instanceof MultiblockPartBlockEntity) {
            MultiblockPartBlockEntity mpte = (MultiblockPartBlockEntity)tile;
            if (mpte.offsetToMaster != BlockPos.f_121853_) {
                tile = mpte.master();
            }
        }
        if (LubricatedHandler.getHandlerForTile(tile) != null) {
            BlockPos pos = tile.m_58899_();
            ResourceKey key = tile.m_58904_().m_46472_();
            for (LubricatedTileInfo info : lubricatedTiles) {
                if (!info.pos.equals((Object)pos) || info.world != key) continue;
                if (info.ticks >= ticks) {
                    if (additive) {
                        info.ticks = cap == -1 ? (info.ticks += ticks) : Math.min(cap, info.ticks + ticks);
                        return true;
                    }
                    return false;
                }
                info.ticks = ticks;
                return true;
            }
            LubricatedTileInfo lti = new LubricatedTileInfo((ResourceKey<Level>)tile.m_58904_().m_46472_(), tile.m_58899_(), lubricant, ticks);
            lubricatedTiles.add(lti);
            return true;
        }
        return false;
    }

    public static interface ILubricationHandler<E extends BlockEntity> {
        public Tuple<BlockPos, Direction> getGhostBlockPosition(Level var1, E var2);

        public Vec3i getStructureDimensions();

        public boolean isMachineEnabled(Level var1, E var2);

        public BlockEntity isPlacedCorrectly(Level var1, AutoLubricatorTileEntity var2, Direction var3);

        public void lubricateClient(ClientLevel var1, Fluid var2, int var3, E var4);

        public void lubricateServer(ServerLevel var1, Fluid var2, int var3, E var4);

        public void spawnLubricantParticles(ClientLevel var1, AutoLubricatorTileEntity var2, Direction var3, E var4);

        @OnlyIn(value=Dist.CLIENT)
        public void renderPipes(AutoLubricatorTileEntity var1, E var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);
    }

    public static class LubricatedTileInfo {
        public BlockPos pos;
        public ResourceKey<Level> world;
        public Fluid lubricant = Fluids.f_76191_;
        public int ticks;

        public LubricatedTileInfo(ResourceKey<Level> registryKey, BlockPos pos, Fluid lubricant, int ticks) {
            this.world = registryKey;
            this.pos = pos;
            this.ticks = ticks;
            if (lubricant != null && lubricant != Fluids.f_76191_) {
                this.lubricant = lubricant;
            }
        }

        public LubricatedTileInfo(CompoundTag tag) {
            int ticks = tag.m_128451_("ticks");
            int x = tag.m_128451_("x");
            int y = tag.m_128451_("y");
            int z = tag.m_128451_("z");
            String name = tag.m_128461_("world");
            String lubricantName = tag.m_128461_("lubricant");
            this.world = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(name));
            this.pos = new BlockPos(x, y, z);
            this.ticks = ticks;
            this.lubricant = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(lubricantName));
            if (this.lubricant == null) {
                this.lubricant = Fluids.f_76191_;
            }
        }

        public CompoundTag writeToNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("ticks", this.ticks);
            tag.m_128405_("x", this.pos.m_123341_());
            tag.m_128405_("y", this.pos.m_123342_());
            tag.m_128405_("z", this.pos.m_123343_());
            tag.m_128359_("world", this.world.m_135782_().toString());
            tag.m_128359_("lubricant", this.lubricant.getRegistryName().toString());
            return tag;
        }
    }

    public static class LubricantEffect
    extends ChemthrowerHandler.ChemthrowerEffect {
        public void applyToEntity(LivingEntity target, Player shooter, ItemStack thrower, Fluid fluid) {
            if (target instanceof IronGolem && LubricantHandler.isValidLube(fluid)) {
                int ticks = Math.max(1, (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get() / LubricantHandler.getLubeAmount(fluid)) * 4 / 3;
                MobEffectInstance activeSpeed = target.m_21124_(MobEffects.f_19596_);
                int ticksSpeed = ticks;
                if (activeSpeed != null && activeSpeed.m_19564_() <= 1) {
                    ticksSpeed = Math.min(activeSpeed.m_19557_() + ticks, 1200);
                }
                MobEffectInstance activeStrength = target.m_21124_(MobEffects.f_19600_);
                int ticksStrength = ticks;
                if (activeStrength != null && activeStrength.m_19564_() <= 1) {
                    ticksStrength = Math.min(activeStrength.m_19557_() + ticks, 1200);
                }
                target.m_7292_(new MobEffectInstance(MobEffects.f_19596_, ticksSpeed, 1));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19600_, ticksStrength, 1));
            }
        }

        public void applyToBlock(Level world, HitResult mop, Player shooter, ItemStack thrower, Fluid fluid) {
            if (LubricantHandler.isValidLube(fluid)) {
                int amount = Math.max(1, (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get() / LubricantHandler.getLubeAmount(fluid)) * 2 / 3;
                LubricatedHandler.lubricateTile(world.m_7702_(new BlockPos(mop.m_82450_())), fluid, amount, true, 1200);
            }
        }
    }
}

