/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.generation;

import com.github.alexthe666.citadel.Citadel;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class VillageHouseManager {
    public static final List<String> VILLAGE_REPLACEMENT_POOLS = List.of("minecraft:village/plains/houses", "minecraft:village/desert/houses", "minecraft:village/savanna/houses", "minecraft:village/snowy/houses", "minecraft:village/taiga/houses");
    private static final List<Pair<String, Consumer<StructureTemplatePool>>> REGISTRY = new ArrayList<Pair<String, Consumer<StructureTemplatePool>>>();

    public static void register(String pool, Consumer<StructureTemplatePool> addToPool) {
        REGISTRY.add((Pair<String, Consumer<StructureTemplatePool>>)new Pair((Object)pool, addToPool));
        Citadel.LOGGER.debug("registered addition to pool: " + pool);
    }

    public static StructureTemplatePool addToPool(StructureTemplatePool pool, StructurePoolElement element, int weight) {
        ArrayList<StructurePoolElement> templates;
        if (weight > 0 && pool != null && !(templates = new ArrayList<StructurePoolElement>(pool.f_210560_)).contains(element)) {
            for (int i = 0; i < weight; ++i) {
                templates.add(element);
            }
            ArrayList<Pair> rawTemplates = new ArrayList<Pair>(pool.f_210559_);
            rawTemplates.add(new Pair((Object)element, (Object)weight));
            pool.f_210560_ = templates;
            pool.f_210559_ = rawTemplates;
            Citadel.LOGGER.info("Added to " + pool.m_210587_() + " structure pool");
        }
        return pool;
    }

    public static void addAllHouses(RegistryAccess registryAccess) {
        try {
            for (String villagePool : VILLAGE_REPLACEMENT_POOLS) {
                StructureTemplatePool pool = registryAccess.m_175515_(Registry.f_122884_).m_6612_(new ResourceLocation(villagePool)).orElse(null);
                if (pool == null) continue;
                String poolName = pool.m_210587_().toString();
                for (Pair<String, Consumer<StructureTemplatePool>> pair : REGISTRY) {
                    if (!((String)pair.getFirst()).equals(poolName)) continue;
                    ((Consumer)pair.getSecond()).accept(pool);
                }
            }
        }
        catch (Exception e) {
            Citadel.LOGGER.error("Could not add village houses!");
            e.printStackTrace();
        }
    }
}

