/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.creative_energy;

import com.mrh0.createaddition.energy.CreativeEnergyStorage;
import com.simibubi.create.content.logistics.crate.CrateBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CreativeEnergyBlockEntity
extends CrateBlockEntity {
    protected final CreativeEnergyStorage energy;
    private LazyOptional<IEnergyStorage> lazyEnergy;
    private boolean firstTickState = true;
    private LazyOptional<IEnergyStorage> escacheUp = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheDown = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheNorth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheEast = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheSouth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheWest = LazyOptional.empty();

    public CreativeEnergyBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.energy = new CreativeEnergyStorage();
        this.lazyEnergy = LazyOptional.of(() -> this.energy);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.lazyEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        for (Direction d : Direction.values()) {
            IEnergyStorage ies = this.getCachedEnergy(d);
            if (ies == null) continue;
            int n = ies.receiveEnergy(Integer.MAX_VALUE, false);
        }
    }

    public void remove() {
        this.lazyEnergy.invalidate();
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        for (Direction side : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(side));
            if (te == null) {
                this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
                continue;
            }
            LazyOptional le = te.getCapability(CapabilityEnergy.ENERGY, side.m_122424_());
            this.setCache(side, (LazyOptional<IEnergyStorage>)le);
        }
    }

    public void setCache(Direction side, LazyOptional<IEnergyStorage> storage) {
        switch (side) {
            case DOWN: {
                this.escacheDown = storage;
                break;
            }
            case EAST: {
                this.escacheEast = storage;
                break;
            }
            case NORTH: {
                this.escacheNorth = storage;
                break;
            }
            case SOUTH: {
                this.escacheSouth = storage;
                break;
            }
            case UP: {
                this.escacheUp = storage;
                break;
            }
            case WEST: {
                this.escacheWest = storage;
            }
        }
    }

    public IEnergyStorage getCachedEnergy(Direction side) {
        switch (side) {
            case DOWN: {
                return (IEnergyStorage)this.escacheDown.orElse(null);
            }
            case EAST: {
                return (IEnergyStorage)this.escacheEast.orElse(null);
            }
            case NORTH: {
                return (IEnergyStorage)this.escacheNorth.orElse(null);
            }
            case SOUTH: {
                return (IEnergyStorage)this.escacheSouth.orElse(null);
            }
            case UP: {
                return (IEnergyStorage)this.escacheUp.orElse(null);
            }
            case WEST: {
                return (IEnergyStorage)this.escacheWest.orElse(null);
            }
        }
        return null;
    }
}

