/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.ClientTagUpdateEvent;
import com.almostreliable.unified.compat.HideHelper;
import com.almostreliable.unified.compat.RecipeIndicator;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.recipe.CRTLookup;
import com.almostreliable.unified.recipe.ClientRecipeTracker;
import com.almostreliable.unified.utils.Utils;
import java.util.List;
import javax.annotation.Nullable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.category.extension.CategoryExtensionProvider;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.renderer.Rect2i;

public class AlmostREI
implements REIClientPlugin {
    @Nullable
    private BasicFilteringRule.MarkDirty filterUpdate;

    public AlmostREI() {
        ClientTagUpdateEvent.register(() -> {
            if (this.filterUpdate != null) {
                this.filterUpdate.markDirty();
            }
        });
    }

    public String getPluginProviderName() {
        return Utils.prefix("roughlyenoughitems");
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        this.filterUpdate = rule.hide(() -> {
            UnifyConfig config = Config.load("unify", new UnifyConfig.Serializer());
            if (config.reiOrJeiDisabled()) {
                return List.of();
            }
            return EntryIngredients.ofItemStacks(HideHelper.createHidingList(config));
        });
    }

    public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        if (stage != ReloadStage.END || !manager.equals((Object)PluginManager.getClientInstance())) {
            return;
        }
        CategoryRegistry.getInstance().forEach(category -> {
            IndicatorExtension extension = new IndicatorExtension(category.getPlusButtonArea().orElse(null));
            category.registerExtension((CategoryExtensionProvider)Utils.cast(extension));
        });
    }

    private record IndicatorExtension(@Nullable ButtonArea plusButtonArea) implements CategoryExtensionProvider<Display>
    {
        public DisplayCategoryView<Display> provide(Display display, DisplayCategory<Display> category, DisplayCategoryView<Display> lastView) {
            return display.getDisplayLocation().map(CRTLookup::getLink).map(link -> new IndicatorView(lastView, (ClientRecipeTracker.ClientRecipeLink)link)).orElse(lastView);
        }

        private final class IndicatorView
        implements DisplayCategoryView<Display> {
            private final DisplayCategoryView<Display> lastView;
            private final ClientRecipeTracker.ClientRecipeLink link;

            private IndicatorView(DisplayCategoryView<Display> lastView, ClientRecipeTracker.ClientRecipeLink link) {
                this.lastView = lastView;
                this.link = link;
            }

            public DisplayRenderer getDisplayRenderer(Display display) {
                return this.lastView.getDisplayRenderer(display);
            }

            public List<Widget> setupDisplay(Display display, Rectangle bounds) {
                List widgets = this.lastView.setupDisplay(display, bounds);
                Rect2i area = this.calculateArea(bounds);
                widgets.add(Widgets.createDrawableWidget((helper, stack, mX, mY, delta) -> RecipeIndicator.renderIndicator(stack, area)));
                Rectangle tooltipArea = new Rectangle(area.m_110085_(), area.m_110086_(), area.m_110090_(), area.m_110091_());
                widgets.add(Widgets.createTooltip((Rectangle)tooltipArea, RecipeIndicator.constructTooltip(this.link)));
                return widgets;
            }

            private Rect2i calculateArea(Rectangle bounds) {
                if (IndicatorExtension.this.plusButtonArea != null) {
                    Rectangle area = IndicatorExtension.this.plusButtonArea.get(bounds);
                    return new Rect2i(area.x, area.y - area.height - 2, area.width, area.height);
                }
                return new Rect2i(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
    }
}

