/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.api;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.Platform;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UnifyTag;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class StoneStrataHandler {
    private final List<String> stoneStrata;
    private final Pattern tagMatcher;
    private final TagMap stoneStrataTagMap;
    private final Map<UnifyTag<?>, Boolean> stoneStrataTagCache;
    private final Map<ResourceLocation, String> stoneStrataCache;

    private StoneStrataHandler(List<String> stoneStrata, Pattern tagMatcher, TagMap stoneStrataTagMap) {
        this.stoneStrata = StoneStrataHandler.createSortedStoneStrata(stoneStrata);
        this.tagMatcher = tagMatcher;
        this.stoneStrataTagMap = stoneStrataTagMap;
        this.stoneStrataTagCache = new HashMap();
        this.stoneStrataCache = new HashMap<ResourceLocation, String>();
    }

    private static List<String> createSortedStoneStrata(List<String> stoneStrata) {
        return stoneStrata.stream().sorted(Comparator.comparingInt(String::length).reversed()).toList();
    }

    public static StoneStrataHandler create(List<String> stoneStrataIds, Set<UnifyTag<Item>> stoneStrataTags, TagMap tagMap) {
        TagMap stoneStrataTagMap = tagMap.filtered(stoneStrataTags::contains, item -> true);
        Pattern tagMatcher = Pattern.compile(switch (AlmostUnifiedPlatform.INSTANCE.getPlatform()) {
            default -> throw new IncompatibleClassChangeError();
            case Platform.FORGE -> "forge:ores/.+";
            case Platform.FABRIC -> "(c:ores/.+|c:.+_ores)";
        });
        return new StoneStrataHandler(stoneStrataIds, tagMatcher, stoneStrataTagMap);
    }

    public String getStoneStrata(ResourceLocation item) {
        return this.stoneStrataCache.computeIfAbsent(item, this::computeStoneStrata);
    }

    private String computeStoneStrata(ResourceLocation item) {
        String strata = this.stoneStrataTagMap.getTags(item).stream().findFirst().map(UnifyTag::location).map(ResourceLocation::toString).map(s -> {
            int i = s.lastIndexOf(47);
            return i == -1 ? null : s.substring(i + 1);
        }).orElse(null);
        if (strata != null) {
            if (strata.equals("stone")) {
                return "";
            }
            return strata;
        }
        for (String stone : this.stoneStrata) {
            if (!item.m_135815_().contains(stone + "_")) continue;
            if (stone.equals("stone")) {
                return "";
            }
            return stone;
        }
        return "";
    }

    public boolean isStoneStrataTag(UnifyTag<Item> tag) {
        return this.stoneStrataTagCache.computeIfAbsent(tag, t -> this.tagMatcher.matcher(t.location().toString()).matches());
    }
}

