/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ES6Iterator;
import dev.latvian.mods.rhino.Hashtable;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import java.util.Collections;
import java.util.Iterator;

public class NativeCollectionIterator
extends ES6Iterator {
    private final String className;
    private final Type type;
    private transient Iterator<Hashtable.Entry> iterator = Collections.emptyIterator();

    static void init(ScriptableObject scope, String tag, boolean sealed) {
        NativeCollectionIterator.init(scope, sealed, new NativeCollectionIterator(tag), tag);
    }

    public NativeCollectionIterator(String tag) {
        this.className = tag;
        this.iterator = Collections.emptyIterator();
        this.type = Type.BOTH;
    }

    public NativeCollectionIterator(Scriptable scope, String className, Type type, Iterator<Hashtable.Entry> iterator) {
        super(scope, className);
        this.className = className;
        this.iterator = iterator;
        this.type = type;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    protected boolean isDone(Context cx, Scriptable scope) {
        return !this.iterator.hasNext();
    }

    @Override
    protected Object nextValue(Context cx, Scriptable scope) {
        Hashtable.Entry e = this.iterator.next();
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.KEYS -> e.key;
            case Type.VALUES -> e.value;
            case Type.BOTH -> cx.newArray(scope, new Object[]{e.key, e.value});
        };
    }

    static enum Type {
        KEYS,
        VALUES,
        BOTH;

    }
}

