/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SubCategoryListEntry
extends TooltipListEntry<List<AbstractConfigListEntry>>
implements Expandable {
    private static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
    private final List<AbstractConfigListEntry> entries;
    private final CategoryLabelWidget widget;
    private final List<Object> children;
    private boolean expanded;

    @Deprecated
    public SubCategoryListEntry(Component categoryName, List<AbstractConfigListEntry> entries, boolean defaultExpanded) {
        super(categoryName, null);
        this.entries = entries;
        this.expanded = defaultExpanded;
        this.widget = new CategoryLabelWidget();
        this.children = Lists.newArrayList((Object[])new Object[]{this.widget});
        this.children.addAll(entries);
        this.setReferenceProviderEntries(entries);
    }

    @Override
    public Iterator<String> getSearchTags() {
        return Iterators.concat(super.getSearchTags(), (Iterator)Iterators.concat(this.entries.stream().map(AbstractConfigEntry::getSearchTags).iterator()));
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean isRequiresRestart() {
        for (AbstractConfigListEntry entry : this.entries) {
            if (!entry.isRequiresRestart()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRequiresRestart(boolean requiresRestart) {
    }

    public Component getCategoryName() {
        return this.getFieldName();
    }

    @Override
    public List<AbstractConfigListEntry> getValue() {
        return this.entries;
    }

    public List<AbstractConfigListEntry> filteredEntries() {
        return new AbstractList<AbstractConfigListEntry>(){

            @Override
            public Iterator<AbstractConfigListEntry> iterator() {
                return Iterators.filter(SubCategoryListEntry.this.entries.iterator(), entry -> SubCategoryListEntry.this.getConfigScreen() != null && SubCategoryListEntry.this.getConfigScreen().matchesSearch(entry.getSearchTags()));
            }

            @Override
            public AbstractConfigListEntry get(int index) {
                return (AbstractConfigListEntry)Iterators.get(this.iterator(), (int)index);
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }
        };
    }

    @Override
    public Optional<List<AbstractConfigListEntry>> getDefaultValue() {
        return Optional.empty();
    }

    @Override
    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONFIG_TEX);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(matrices, x - 15, y + 5, 24, (this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9);
        Minecraft.m_91087_().f_91062_.m_92744_(matrices, this.getDisplayedFieldName().m_7532_(), (float)x, (float)(y + 6), this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
        for (AbstractConfigListEntry entry : this.entries) {
            entry.setParent(this.getParent());
            entry.setScreen(this.getConfigScreen());
        }
        if (this.expanded) {
            int yy = y + 24;
            for (AbstractConfigListEntry entry : this.filteredEntries()) {
                entry.render(matrices, -1, yy, x + 14, entryWidth - 14, entry.getItemHeight(), mouseX, mouseY, isHovered && this.m_7222_() == entry, delta);
                yy += entry.getItemHeight();
            }
        }
    }

    @Override
    public void updateSelected(boolean isSelected) {
        for (AbstractConfigListEntry entry : this.entries) {
            entry.updateSelected(this.expanded && isSelected && this.m_7222_() == entry && this.getConfigScreen().matchesSearch(entry.getSearchTags()));
        }
    }

    @Override
    public boolean isEdited() {
        for (AbstractConfigListEntry entry : this.entries) {
            if (!entry.isEdited()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void lateRender(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.expanded) {
            for (AbstractConfigListEntry entry : this.filteredEntries()) {
                entry.lateRender(matrices, mouseX, mouseY, delta);
            }
        }
    }

    @Override
    public int getMorePossibleHeight() {
        if (!this.expanded) {
            return -1;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 24;
        for (AbstractConfigListEntry entry : this.filteredEntries()) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
    }

    @Override
    public Rectangle getEntryArea(int x, int y, int entryWidth, int entryHeight) {
        this.widget.rectangle.x = x - 15;
        this.widget.rectangle.y = y;
        this.widget.rectangle.width = entryWidth + 15;
        this.widget.rectangle.height = 24;
        return new Rectangle(this.getParent().left, y, this.getParent().right - this.getParent().left, 20);
    }

    @Override
    public int getItemHeight() {
        if (this.expanded) {
            int i = 24;
            for (AbstractConfigListEntry entry : this.filteredEntries()) {
                i += entry.getItemHeight();
            }
            return i;
        }
        return 24;
    }

    @Override
    public int getInitialReferenceOffset() {
        return 24;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.expanded ? this.children : Collections.singletonList(this.widget);
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return this.expanded ? this.children : Collections.singletonList(this.widget);
    }

    @Override
    public void save() {
        this.entries.forEach(AbstractConfigEntry::save);
    }

    @Override
    public Optional<Component> getError() {
        Object error = null;
        for (AbstractConfigListEntry entry : this.entries) {
            Optional<Component> configError = entry.getConfigError();
            if (!configError.isPresent()) continue;
            if (error != null) {
                return Optional.ofNullable(new TranslatableComponent("text.cloth-config.multi_error"));
            }
            return configError;
        }
        return Optional.ofNullable(error);
    }

    public class CategoryLabelWidget
    implements GuiEventListener,
    NarratableEntry {
        private final Rectangle rectangle = new Rectangle();
        private boolean isHovered;

        public boolean m_6375_(double double_1, double double_2, int int_1) {
            if (this.rectangle.contains(double_1, double_2)) {
                SubCategoryListEntry.this.expanded = !SubCategoryListEntry.this.expanded;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                this.isHovered = true;
                return true;
            }
            this.isHovered = false;
            return false;
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return this.isHovered ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, SubCategoryListEntry.this.getFieldName());
        }
    }
}

