/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class KeyCodeEntry
extends TooltipListEntry<ModifierKeyCode> {
    private ModifierKeyCode value;
    private final ModifierKeyCode original;
    private final Button buttonWidget;
    private final Button resetButton;
    private final Supplier<ModifierKeyCode> defaultValue;
    private final List<AbstractWidget> widgets;
    private boolean allowMouse = true;
    private boolean allowKey = true;
    private boolean allowModifiers = true;

    @Deprecated
    @ApiStatus.Internal
    public KeyCodeEntry(Component fieldName, ModifierKeyCode value, Component resetButtonKey, Supplier<ModifierKeyCode> defaultValue, Consumer<ModifierKeyCode> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.value = value.copy();
        this.original = value.copy();
        this.buttonWidget = new Button(0, 0, 150, 20, NarratorChatListener.f_93310_, widget -> this.getConfigScreen().setFocusedBinding(this));
        this.resetButton = new Button(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)resetButtonKey) + 6, 20, resetButtonKey, widget -> {
            this.value = ((ModifierKeyCode)this.getDefaultValue().orElse(null)).copy();
            this.getConfigScreen().setFocusedBinding(null);
        });
        this.saveCallback = saveConsumer;
        this.widgets = Lists.newArrayList((Object[])new AbstractWidget[]{this.buttonWidget, this.resetButton});
    }

    @Override
    public boolean isEdited() {
        return super.isEdited() || !this.original.equals(this.getValue());
    }

    public boolean isAllowModifiers() {
        return this.allowModifiers;
    }

    public void setAllowModifiers(boolean allowModifiers) {
        this.allowModifiers = allowModifiers;
    }

    public boolean isAllowKey() {
        return this.allowKey;
    }

    public void setAllowKey(boolean allowKey) {
        this.allowKey = allowKey;
    }

    public boolean isAllowMouse() {
        return this.allowMouse;
    }

    public void setAllowMouse(boolean allowMouse) {
        this.allowMouse = allowMouse;
    }

    @Override
    public ModifierKeyCode getValue() {
        return this.value;
    }

    public void setValue(ModifierKeyCode value) {
        this.value = value;
    }

    @Override
    public Optional<ModifierKeyCode> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue).map(Supplier::get).map(ModifierKeyCode::copy);
    }

    private Component getLocalizedName() {
        return this.value.getLocalizedName();
    }

    @Override
    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        Window window = Minecraft.m_91087_().m_91268_();
        this.resetButton.f_93623_ = this.isEditable() && this.getDefaultValue().isPresent() && !this.getDefaultValue().get().equals(this.getValue());
        this.resetButton.f_93621_ = y;
        this.buttonWidget.f_93623_ = this.isEditable();
        this.buttonWidget.f_93621_ = y;
        this.buttonWidget.m_93666_(this.getLocalizedName());
        if (this.getConfigScreen().getFocusedBinding() == this) {
            this.buttonWidget.m_93666_((Component)new TextComponent("> ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)this.buttonWidget.m_6035_().m_6879_().m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)new TextComponent(" <").m_130940_(ChatFormatting.WHITE)));
        }
        Component displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.m_91087_().f_91062_.m_92718_()) {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, displayedFieldName.m_7532_(), (float)(window.m_85445_() - x - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)displayedFieldName)), (float)(y + 6), 0xFFFFFF);
            this.resetButton.f_93620_ = x;
            this.buttonWidget.f_93620_ = x + this.resetButton.m_5711_() + 2;
        } else {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, displayedFieldName.m_7532_(), (float)x, (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.f_93620_ = x + entryWidth - this.resetButton.m_5711_();
            this.buttonWidget.f_93620_ = x + entryWidth - 150;
        }
        this.buttonWidget.m_93674_(150 - this.resetButton.m_5711_() - 2);
        this.resetButton.m_6305_(matrices, mouseX, mouseY, delta);
        this.buttonWidget.m_6305_(matrices, mouseX, mouseY, delta);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return this.widgets;
    }
}

