/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.network.EnderStorageNetwork;
import codechicken.enderstorage.network.TankSynchroniser;
import codechicken.enderstorage.storage.EnderLiquidStorage;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.capability.CapabilityCache;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.fluid.FluidUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class TileEnderTank
extends TileFrequencyOwner {
    public int rotation;
    public final EnderTankState liquid_state = new EnderTankState();
    public final PressureState pressure_state = new PressureState();
    private final CapabilityCache capCache = new CapabilityCache();
    private LazyOptional<IFluidHandler> fluidHandler = LazyOptional.empty();
    private boolean described;

    public TileEnderTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnderStorageModContent.ENDER_TANK_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        this.capCache.tick();
        this.pressure_state.update(this.f_58857_.f_46443_);
        if (this.pressure_state.a_pressure) {
            this.ejectLiquid();
        }
        this.liquid_state.update(this.f_58857_.f_46443_);
    }

    @Override
    public void m_142339_(Level p_155231_) {
        super.m_142339_(p_155231_);
        this.capCache.setWorldPos(this.m_58904_(), this.m_58899_());
    }

    @Override
    public void onNeighborChange(BlockPos from) {
        this.capCache.onNeighborChanged(from);
    }

    private void ejectLiquid() {
        EnderLiquidStorage source = this.getStorage();
        for (Direction side : Direction.f_122348_) {
            int qty;
            IFluidHandler dest = (IFluidHandler)this.capCache.getCapabilityOr(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side, (Object)EmptyFluidHandler.INSTANCE);
            FluidStack drain = source.drain(100, IFluidHandler.FluidAction.SIMULATE);
            if (drain.isEmpty() || (qty = dest.fill(drain, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
            source.drain(qty, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void onFrequencySet() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.liquid_state.setFrequency(this.frequency);
        }
        this.fluidHandler.invalidate();
        this.fluidHandler = LazyOptional.of(this::getStorage);
    }

    public void m_7651_() {
        super.m_7651_();
        this.fluidHandler.invalidate();
    }

    @Override
    public EnderLiquidStorage getStorage() {
        return EnderStorageManager.instance(this.f_58857_.f_46443_).getStorage(this.frequency, EnderLiquidStorage.TYPE);
    }

    @Override
    public void onPlaced(LivingEntity entity) {
        this.rotation = entity != null ? (int)Math.floor((double)(entity.m_146908_() * 4.0f / 360.0f) + 2.5) & 3 : 0;
        this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
        if (!this.f_58857_.f_46443_) {
            this.sendUpdatePacket();
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("rot", (byte)this.rotation);
        tag.m_128379_("ir", this.pressure_state.invert_redstone);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.liquid_state.setFrequency(this.frequency);
        this.rotation = tag.m_128445_("rot") & 3;
        this.pressure_state.invert_redstone = tag.m_128471_("ir");
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeByte(this.rotation);
        packet.writeFluidStack(this.liquid_state.s_liquid);
        packet.writeBoolean(this.pressure_state.a_pressure);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.liquid_state.setFrequency(this.frequency);
        this.rotation = packet.readUByte() & 3;
        this.liquid_state.s_liquid = packet.readFluidStack();
        this.pressure_state.a_pressure = packet.readBoolean();
        if (!this.described) {
            this.liquid_state.c_liquid = this.liquid_state.s_liquid;
            this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
        }
        this.described = true;
    }

    @Override
    public boolean activate(Player player, int subHit, InteractionHand hand) {
        if (subHit == 4) {
            this.pressure_state.invert();
            return true;
        }
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.getStorage());
    }

    @Override
    public int getLightValue() {
        if (this.liquid_state.s_liquid.getAmount() > 0) {
            return FluidUtils.getLuminosity((FluidStack)this.liquid_state.c_liquid, (double)((double)this.liquid_state.s_liquid.getAmount() / 16.0));
        }
        return 0;
    }

    @Override
    public boolean redstoneInteraction() {
        return true;
    }

    @Override
    public boolean rotate() {
        if (!this.f_58857_.f_46443_) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((Packet)this.m_183216_(), (Level)this.f_58857_, (int)(this.f_58858_.m_123341_() >> 4), (int)(this.f_58858_.m_123343_() >> 4));
        }
        return true;
    }

    @Override
    public int comparatorInput() {
        EnderLiquidStorage tank = this.getStorage();
        FluidStack fluid = tank.getFluid();
        if (fluid == null) {
            fluid = FluidStack.EMPTY;
        }
        return fluid.getAmount() * 14 / tank.getCapacity() + (fluid.getAmount() > 0 ? 1 : 0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public class EnderTankState
    extends TankSynchroniser.TankState {
        @Override
        public void sendSyncPacket() {
            PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 4);
            packet.writePos(TileEnderTank.this.m_58899_());
            packet.writeFluidStack(this.s_liquid);
            packet.sendToChunk((BlockEntity)TileEnderTank.this);
        }

        @Override
        public void onLiquidChanged() {
            TileEnderTank.this.f_58857_.m_7726_().m_7827_().m_142202_(TileEnderTank.this.f_58858_);
        }
    }

    public class PressureState {
        public boolean invert_redstone;
        public boolean a_pressure;
        public boolean b_pressure;
        public double a_rotate;
        public double b_rotate;

        public void update(boolean client) {
            if (client) {
                this.b_rotate = this.a_rotate;
                this.a_rotate = MathHelper.approachExp((double)this.a_rotate, (double)this.approachRotate(), (double)0.5, (double)20.0);
            } else {
                this.b_pressure = this.a_pressure;
                boolean bl = this.a_pressure = TileEnderTank.this.f_58857_.m_46753_(TileEnderTank.this.m_58899_()) != this.invert_redstone;
                if (this.a_pressure != this.b_pressure) {
                    this.sendSyncPacket();
                }
            }
        }

        public double approachRotate() {
            return this.a_pressure ? -90.0 : 90.0;
        }

        private void sendSyncPacket() {
            PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 5);
            packet.writePos(TileEnderTank.this.m_58899_());
            packet.writeBoolean(this.a_pressure);
            packet.sendToChunk((BlockEntity)TileEnderTank.this);
        }

        public void invert() {
            this.invert_redstone = !this.invert_redstone;
            TileEnderTank.this.f_58857_.m_46865_(TileEnderTank.this.f_58858_).m_8092_(true);
        }
    }
}

