/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.EarmuffsItem;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class IEBlockEntitySound
implements TickableSoundInstance {
    protected Sound sound;
    private final SoundSource category;
    public SoundInstance.Attenuation attenuation;
    public final ResourceLocation resource;
    public float volume;
    public float pitch;
    public int tileX;
    public int tileY;
    public int tileZ;
    public boolean canRepeat;
    public int repeatDelay;
    public float volumeAjustment = 1.0f;
    public float[] origPos;
    public boolean donePlaying = false;

    public IEBlockEntitySound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, int x, int y, int z, SoundInstance.Attenuation attenuation, SoundSource category) {
        this.attenuation = attenuation;
        this.resource = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.tileX = x;
        this.tileY = y;
        this.tileZ = z;
        this.canRepeat = repeat;
        this.repeatDelay = repeatDelay;
        this.origPos = new float[]{x, y, z};
        this.category = category;
    }

    public IEBlockEntitySound(SoundEvent event, float volume, float pitch, boolean repeat, int repeatDelay, BlockPos pos, SoundInstance.Attenuation attenuation, SoundSource category) {
        this(event.m_11660_(), volume, pitch, repeat, repeatDelay, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), attenuation, category);
    }

    public SoundInstance.Attenuation m_7438_() {
        return this.attenuation;
    }

    public ResourceLocation m_7904_() {
        return this.resource;
    }

    @Nullable
    public WeighedSoundEvents m_6775_(SoundManager handler) {
        WeighedSoundEvents soundEvent = handler.m_120384_(this.resource);
        this.sound = soundEvent == null ? SoundManager.f_120344_ : soundEvent.m_6776_();
        return soundEvent;
    }

    public Sound m_5891_() {
        return this.sound;
    }

    public SoundSource m_8070_() {
        return this.category;
    }

    public float m_7769_() {
        return this.volume * this.volumeAjustment;
    }

    public float m_7783_() {
        return this.pitch;
    }

    public double m_7772_() {
        return this.tileX;
    }

    public double m_7780_() {
        return this.tileY;
    }

    public double m_7778_() {
        return this.tileZ;
    }

    public boolean m_7775_() {
        return this.canRepeat;
    }

    public boolean m_7796_() {
        return false;
    }

    public int m_7766_() {
        return this.repeatDelay;
    }

    public void evaluateVolume() {
        BlockEntity tile;
        ItemStack earmuffs;
        this.volumeAjustment = 1.0f;
        if (ClientUtils.mc().f_91074_ != null && !(earmuffs = EarmuffsItem.EARMUFF_GETTERS.getFrom((LivingEntity)ClientUtils.mc().f_91074_)).m_41619_()) {
            this.volumeAjustment = EarmuffsItem.getVolumeMod(earmuffs);
        }
        if (!((tile = ClientUtils.mc().f_91074_.f_19853_.m_7702_(new BlockPos(this.tileX, this.tileY, this.tileZ))) instanceof IEBlockInterfaces.ISoundBE)) {
            this.donePlaying = true;
        } else {
            IEBlockInterfaces.ISoundBE soundBE = (IEBlockInterfaces.ISoundBE)tile;
            boolean bl = this.donePlaying = !soundBE.shouldPlaySound(this.resource.toString());
            if (!this.donePlaying) {
                float radiusSq = soundBE.getSoundRadiusSq();
                if (ClientUtils.mc().f_91074_ != null) {
                    double distSq = ClientUtils.mc().f_91074_.m_20275_((double)this.tileX, (double)this.tileY, (double)this.tileZ);
                    if (distSq > (double)radiusSq) {
                        this.donePlaying = true;
                    } else {
                        this.volumeAjustment = (float)((double)this.volumeAjustment * (((double)radiusSq - distSq) / (double)radiusSq));
                    }
                }
            }
        }
    }

    public void m_7788_() {
        if (ClientUtils.mc().f_91074_ != null && ClientUtils.mc().f_91074_.f_19853_.m_46467_() % 40L == 0L) {
            this.evaluateVolume();
        }
    }

    public boolean m_7801_() {
        return this.donePlaying;
    }
}

