/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionGenericRemoveRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.ActionAddRecipeCustomOutput;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.fluid.MCFluidStackMutable;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Squeezer")
@ZenCodeType.Name(value="mods.immersiveengineering.Squeezer")
public class SqueezerRecipeManager
implements IRecipeManager<SqueezerRecipe> {
    public RecipeType<SqueezerRecipe> getRecipeType() {
        return SqueezerRecipe.TYPE;
    }

    @ZenCodeType.Method
    public void remove(final IFluidStack fluidStack) {
        CraftTweakerAPI.apply((IAction)new AbstractActionGenericRemoveRecipe<SqueezerRecipe>((IRecipeManager)this, (CommandStringDisplayable)fluidStack){

            @Override
            public boolean shouldRemove(SqueezerRecipe recipe) {
                return recipe.fluidOutput.isFluidStackIdentical(fluidStack.getInternal());
            }
        });
    }

    @ZenCodeType.Method
    public void remove(final Fluid fluid) {
        CraftTweakerAPI.apply((IAction)new AbstractActionGenericRemoveRecipe<SqueezerRecipe>((IRecipeManager)this, fluid){

            @Override
            public boolean shouldRemove(SqueezerRecipe recipe) {
                return fluid.m_6212_(recipe.fluidOutput.getFluid());
            }
        });
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount input, int energy, IFluidStack fluidOutput, @ZenCodeType.Optional(value="<item:minecraft:air>") IItemStack itemOutput) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        IngredientWithSize inputWithSize = CrTIngredientUtil.getIngredientWithSize(input);
        FluidStack fluidOut = fluidOutput.getInternal();
        ItemStack itemOut = itemOutput.getInternal();
        SqueezerRecipe recipe = IEServerConfig.MACHINES.squeezerConfig.apply(new SqueezerRecipe(resourceLocation, fluidOut, IESerializableRecipe.of(itemOut), inputWithSize, energy));
        String outputDescription = String.format("%s and %s", fluidOutput.getCommandString(), itemOutput.getCommandString());
        CraftTweakerAPI.apply(new ActionAddRecipeCustomOutput<SqueezerRecipe>(this, recipe, outputDescription));
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount input, int energy, IItemStack itemOutput) {
        this.addRecipe(recipePath, input, energy, (IFluidStack)new MCFluidStackMutable(FluidStack.EMPTY), itemOutput);
    }
}

