/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.client.utils.FontUtils;
import blusunrize.immersiveengineering.common.entities.FluorescentTubeEntity;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;

public class FluorescentTubeItem
extends IEBaseItem
implements IConfigurableTool,
IElectricEquipment,
IEItemInterfaces.IColouredItem {
    private static final String LIT_TIME = "litTime";
    public static final String LIT_STRENGTH = "litStrength";

    public FluorescentTubeItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void initializeClient(@Nonnull Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Direction side = ctx.m_43719_();
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        if (side == Direction.UP && player != null) {
            if (!world.f_46443_) {
                ItemStack stack = ctx.m_43722_();
                Vec3 look = player.m_20154_();
                float angle = (float)Math.toDegrees(Math.atan2(look.f_82479_, look.f_82481_));
                FluorescentTubeEntity tube = new FluorescentTubeEntity(world, stack.m_41777_(), angle);
                tube.m_6034_(ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_ + 1.5, ctx.m_43720_().f_82481_);
                world.m_7967_((Entity)tube);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(ctx);
    }

    public static float[] getRGB(ItemStack s) {
        if (ItemNBTHelper.hasKey(s, "rgb")) {
            CompoundTag nbt = ItemNBTHelper.getTagCompound(s, "rgb");
            return new float[]{nbt.m_128457_("r"), nbt.m_128457_("g"), nbt.m_128457_("b")};
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public static void setRGB(ItemStack s, float[] rgb) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("r", rgb[0]);
        nbt.m_128350_("g", rgb[1]);
        nbt.m_128350_("b", rgb[2]);
        ItemNBTHelper.setTagCompound(s, "rgb", nbt);
    }

    @Override
    public boolean canConfigure(ItemStack stack) {
        return true;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigBoolean[] getBooleanOptions(ItemStack stack) {
        return new IConfigurableTool.ToolConfig.ToolConfigBoolean[0];
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigFloat[] getFloatOptions(ItemStack stack) {
        IConfigurableTool.ToolConfig.ToolConfigFloat[] ret = new IConfigurableTool.ToolConfig.ToolConfigFloat[3];
        float[] rgb = FluorescentTubeItem.getRGB(stack);
        ret[0] = new IConfigurableTool.ToolConfig.ToolConfigFloat("red", 60, 20, rgb[0]);
        ret[1] = new IConfigurableTool.ToolConfig.ToolConfigFloat("green", 60, 40, rgb[1]);
        ret[2] = new IConfigurableTool.ToolConfig.ToolConfigFloat("blue", 60, 60, rgb[2]);
        return ret;
    }

    @Override
    public void applyConfigOption(ItemStack stack, String key, Object value) {
        int id = key.equals("red") ? 0 : (key.equals("green") ? 1 : 2);
        float[] rgb = FluorescentTubeItem.getRGB(stack);
        rgb[id] = ((Float)value).floatValue();
        FluorescentTubeItem.setRGB(stack, rgb);
    }

    @Override
    public String fomatConfigName(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return config.name;
    }

    @Override
    public String fomatConfigDescription(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return config.name;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        int color = FluorescentTubeItem.getRGBInt(stack, 1.0f);
        list.add((Component)FontUtils.withAppendColoredColour((MutableComponent)new TranslatableComponent("desc.immersiveengineering.info.colour"), color));
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        if (pass == 0) {
            return FluorescentTubeItem.getRGBInt(stack, 1.0f);
        }
        return -1;
    }

    public static float[] getRGBFloat(ItemStack stack, float factor) {
        float[] fRGB = FluorescentTubeItem.getRGB(stack);
        return new float[]{fRGB[0] * factor, fRGB[1] * factor, fRGB[2] * factor, 1.0f};
    }

    public static int getRGBInt(ItemStack stack, float factor) {
        float[] scaled = FluorescentTubeItem.getRGBFloat(stack, factor);
        return ((int)(scaled[0] * 255.0f) << 16) + ((int)(scaled[1] * 255.0f) << 8) + (int)(scaled[2] * 255.0f);
    }

    public static boolean isLit(ItemStack stack) {
        return ItemNBTHelper.hasKey(stack, LIT_TIME);
    }

    public static void setLit(ItemStack stack, float strength) {
        ItemNBTHelper.putInt(stack, LIT_TIME, 35);
        ItemNBTHelper.putFloat(stack, LIT_STRENGTH, Mth.m_14036_((float)strength, (float)0.0f, (float)1.0f));
    }

    @Override
    public void onStrike(ItemStack equipped, EquipmentSlot eqSlot, LivingEntity owner, Map<String, Object> cache, DamageSource dmg, IElectricEquipment.ElectricSource eSource) {
        FluorescentTubeItem.setLit(equipped, eSource.level);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.f_46443_ && FluorescentTubeItem.isLit(stack)) {
            int litTicksRemaining = ItemNBTHelper.getInt(stack, LIT_TIME);
            if (--litTicksRemaining <= 0) {
                ItemNBTHelper.remove(stack, LIT_TIME);
                ItemNBTHelper.remove(stack, LIT_STRENGTH);
            } else {
                ItemNBTHelper.putInt(stack, LIT_TIME, litTicksRemaining);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41746_((ItemStack)oldStack, (ItemStack)newStack) || !Arrays.equals(FluorescentTubeItem.getRGB(oldStack), FluorescentTubeItem.getRGB(newStack));
    }
}

