/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.gui.AutoWorkbenchContainer;
import blusunrize.immersiveengineering.common.gui.BlueprintInventory;
import blusunrize.immersiveengineering.common.gui.MaintenanceKitContainer;
import blusunrize.immersiveengineering.common.gui.ModWorkbenchContainer;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.inventory.EmptyContainer;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class IESlot
extends Slot {
    final AbstractContainerMenu containerMenu;

    public IESlot(AbstractContainerMenu containerMenu, Container inv, int id, int x, int y) {
        super(inv, id, x, y);
        this.containerMenu = containerMenu;
    }

    public boolean m_5857_(ItemStack itemStack) {
        return true;
    }

    public static interface ICallbackContainer {
        public boolean canInsert(ItemStack var1, int var2, Slot var3);

        public boolean canTake(ItemStack var1, int var2, Slot var3);
    }

    public static class LogicCircuit
    extends IESlot {
        public LogicCircuit(AbstractContainerMenu container, Container inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        public int m_6641_() {
            return 1;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return itemStack.m_41720_().equals((Object)IEItems.Misc.LOGIC_CIRCUIT_BOARD.get());
        }
    }

    public static class ContainerCallback
    extends SlotItemHandler {
        AbstractContainerMenu f_40218_;

        public ContainerCallback(AbstractContainerMenu container, IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
            this.f_40218_ = container;
        }

        public boolean m_5857_(ItemStack itemStack) {
            if (this.f_40218_ instanceof ICallbackContainer) {
                return ((ICallbackContainer)this.f_40218_).canInsert(itemStack, this.getSlotIndex(), (Slot)this);
            }
            return true;
        }

        public boolean m_8010_(Player player) {
            if (this.f_40218_ instanceof ICallbackContainer) {
                return ((ICallbackContainer)this.f_40218_).canTake(this.m_7993_(), this.getSlotIndex(), (Slot)this);
            }
            return true;
        }
    }

    public static class AlwaysEmptySlot
    extends IESlot {
        public AlwaysEmptySlot(AbstractContainerMenu containerMenu) {
            super(containerMenu, EmptyContainer.INSTANCE, 0, 0, 0);
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return false;
        }

        public boolean m_6659_() {
            return false;
        }
    }

    public static class Tagged
    extends IESlot {
        private final TagKey<Item> tag;

        public Tagged(AbstractContainerMenu container, Container inv, int id, int x, int y, TagKey<Item> tag) {
            super(container, inv, id, x, y);
            this.tag = tag;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return itemStack.m_204117_(this.tag);
        }
    }

    public static class Cloche
    extends IESlot {
        private final Level level;
        int type = 0;

        public Cloche(int type, AbstractContainerMenu container, Container inv, int id, int x, int y, Level level) {
            super(container, inv, id, x, y);
            this.type = type;
            this.level = level;
        }

        public int m_6641_() {
            return this.type < 2 ? 1 : 64;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return false;
            }
            if (this.type == 2) {
                return ClocheFertilizer.isValidFertilizer(this.level, itemStack);
            }
            return true;
        }
    }

    public static class ArcElectrode
    extends IESlot {
        public ArcElectrode(AbstractContainerMenu container, Container inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        public int m_6641_() {
            return 1;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return ((Object)((Object)IEItems.Misc.GRAPHITE_ELECTRODE.get())).equals(itemStack.m_41720_());
        }
    }

    public static class ArcAdditive
    extends IESlot {
        private final Level level;

        public ArcAdditive(AbstractContainerMenu container, Container inv, int id, int x, int y, Level level) {
            super(container, inv, id, x, y);
            this.level = level;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return !itemStack.m_41619_() && ArcFurnaceRecipe.isValidRecipeAdditive(this.level, itemStack);
        }
    }

    public static class ArcInput
    extends IESlot {
        private final Level level;

        public ArcInput(AbstractContainerMenu container, Container inv, int id, int x, int y, Level level) {
            super(container, inv, id, x, y);
            this.level = level;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return !itemStack.m_41619_() && ArcFurnaceRecipe.isValidRecipeInput(this.level, itemStack);
        }
    }

    public static class BlueprintOutput
    extends IESlot {
        private final Container inputInventory;
        public final BlueprintCraftingRecipe recipe;

        public BlueprintOutput(AbstractContainerMenu container, BlueprintInventory inv, Container inputInventory, int id, int x, int y, BlueprintCraftingRecipe recipe) {
            super(container, (Container)inv, id, x, y);
            this.inputInventory = inputInventory;
            this.recipe = recipe;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return false;
        }

        public boolean m_6659_() {
            return this.m_6657_();
        }

        public void m_142406_(Player player, ItemStack stack) {
            ((BlueprintInventory)this.f_40218_).reduceIputs(this.inputInventory, this.recipe, stack);
            super.m_142406_(player, stack);
        }
    }

    public static class BlueprintInput
    extends IESlot {
        private final BlueprintInventory outputInventory;

        public BlueprintInput(AbstractContainerMenu container, Container inv, BlueprintInventory outputInventory, int id, int x, int y) {
            super(container, inv, id, x, y);
            this.outputInventory = outputInventory;
        }

        public void m_6654_() {
            this.outputInventory.updateOutputs(this.f_40218_);
            super.m_6654_();
        }
    }

    public static class ItemDisplay
    extends IESlot {
        public ItemDisplay(AbstractContainerMenu container, Container inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return false;
        }

        public boolean m_8010_(Player player) {
            return false;
        }
    }

    public static class ItemHandlerGhost
    extends SlotItemHandler {
        public ItemHandlerGhost(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }
    }

    public static class AutoBlueprint
    extends IESlot {
        public AutoBlueprint(AbstractContainerMenu container, Container inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return !itemStack.m_41619_() && itemStack.m_41720_() instanceof EngineersBlueprintItem;
        }

        public int m_6641_() {
            return 1;
        }

        public void m_6654_() {
            super.m_6654_();
            if (this.containerMenu instanceof AutoWorkbenchContainer) {
                ImmersiveEngineering.proxy.reInitGui();
            }
        }
    }

    public static class Maintenance
    extends IESlot {
        public Maintenance(MaintenanceKitContainer container, Container inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return false;
            }
            if (itemStack.m_41720_() instanceof IUpgradeableTool) {
                return ((IUpgradeableTool)itemStack.m_41720_()).canModify(itemStack);
            }
            if (itemStack.m_41720_() instanceof IConfigurableTool) {
                return ((IConfigurableTool)itemStack.m_41720_()).canConfigure(itemStack);
            }
            return false;
        }

        public void m_6654_() {
            super.m_6654_();
            if (this.containerMenu instanceof MaintenanceKitContainer) {
                ((MaintenanceKitContainer)this.containerMenu).updateSlots();
            }
        }

        public boolean m_8010_(Player player) {
            return this.m_7993_().m_41619_() || !(this.m_7993_().m_41720_() instanceof IUpgradeableTool) || ((IUpgradeableTool)this.m_7993_().m_41720_()).canTakeFromWorkbench(this.m_7993_());
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            if (!stack.m_41619_() && stack.m_41720_() instanceof IUpgradeableTool) {
                ((IUpgradeableTool)stack.m_41720_()).removeFromWorkbench(player, stack);
            }
        }
    }

    public static class ModWorkbench
    extends IESlot {
        int size;

        public ModWorkbench(ModWorkbenchContainer container, Container inv, int id, int x, int y, int size) {
            super(container, inv, id, x, y);
            this.size = size;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return false;
            }
            if (itemStack.m_41720_() instanceof EngineersBlueprintItem) {
                return true;
            }
            if (itemStack.m_41720_() instanceof IUpgradeableTool) {
                return ((IUpgradeableTool)itemStack.m_41720_()).canModify(itemStack);
            }
            if (itemStack.m_41720_() instanceof IConfigurableTool) {
                return ((IConfigurableTool)itemStack.m_41720_()).canConfigure(itemStack);
            }
            return false;
        }

        public int m_6641_() {
            return this.size;
        }

        public void m_6654_() {
            super.m_6654_();
            AbstractContainerMenu abstractContainerMenu = this.containerMenu;
            if (abstractContainerMenu instanceof ModWorkbenchContainer) {
                ModWorkbenchContainer workbench = (ModWorkbenchContainer)abstractContainerMenu;
                workbench.rebindSlots();
            }
        }

        public boolean m_8010_(Player player) {
            IUpgradeableTool tool;
            Item item = this.m_7993_().m_41720_();
            return !(item instanceof IUpgradeableTool && !(tool = (IUpgradeableTool)item).canTakeFromWorkbench(this.m_7993_()));
        }

        public void m_142406_(Player player, ItemStack stack) {
            Item item;
            super.m_142406_(player, stack);
            if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IUpgradeableTool) {
                IUpgradeableTool upgradeableTool = (IUpgradeableTool)item;
                upgradeableTool.removeFromWorkbench(player, stack);
            }
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                if (handler instanceof IEItemStackHandler) {
                    IEItemStackHandler ieHandler = (IEItemStackHandler)((Object)handler);
                    ieHandler.setTile(null);
                }
            });
        }
    }

    public static class Shader
    extends IESlot {
        ItemStack tool;

        public Shader(AbstractContainerMenu container, Container inv, int id, int x, int y, ItemStack tool) {
            super(container, inv, id, x, y);
            this.tool = tool;
            this.setBackground(InventoryMenu.f_39692_, ImmersiveEngineering.rl("item/shader_slot"));
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof IShaderItem) || this.tool.m_41619_()) {
                return false;
            }
            return this.tool.getCapability(CapabilityShader.SHADER_CAPABILITY).map(wrapper -> ((IShaderItem)itemStack.m_41720_()).getShaderCase(itemStack, wrapper.getShaderType()) != null).orElse(false);
        }

        public int m_6641_() {
            return 1;
        }
    }

    public static class Upgrades
    extends SlotItemHandler {
        final ItemStack toolStack;
        private final IUpgradeableTool upgradeableTool;
        private final String type;
        private final boolean preventDoubles;
        private final AbstractContainerMenu container;
        private final Level world;
        private final Supplier<Player> getPlayer;

        public Upgrades(AbstractContainerMenu container, IItemHandler inv, int id, int x, int y, String type, ItemStack toolStack, boolean preventDoubles, Level world, Supplier<Player> getPlayer) {
            super(inv, id, x, y);
            this.container = container;
            this.type = type;
            this.toolStack = toolStack;
            this.upgradeableTool = (IUpgradeableTool)toolStack.m_41720_();
            this.preventDoubles = preventDoubles;
            this.world = world;
            this.getPlayer = getPlayer;
        }

        public boolean m_5857_(@Nonnull ItemStack itemStack) {
            if (this.preventDoubles) {
                for (Slot slot : this.container.f_38839_) {
                    if (this == slot || !(slot instanceof Upgrades) || !ItemStack.m_41746_((ItemStack)slot.m_7993_(), (ItemStack)itemStack)) continue;
                    return false;
                }
            }
            return !itemStack.m_41619_() && itemStack.m_41720_() instanceof IUpgrade && ((IUpgrade)itemStack.m_41720_()).getUpgradeTypes(itemStack).contains(this.type) && ((IUpgrade)itemStack.m_41720_()).canApplyUpgrades(this.toolStack, itemStack);
        }

        public int m_6641_() {
            return 64;
        }

        @Nonnull
        public ItemStack m_7993_() {
            return this.upgradeableTool.getUpgradeAfterRemoval(this.toolStack, super.m_7993_());
        }

        public void m_142406_(Player thePlayer, ItemStack stack) {
            if (!this.world.f_46443_) {
                this.upgradeableTool.removeUpgrade(this.toolStack, thePlayer, stack);
            }
            super.m_142406_(thePlayer, stack);
        }

        public void m_6654_() {
            super.m_6654_();
            if (!this.world.f_46443_) {
                this.upgradeableTool.recalculateUpgrades(this.toolStack, this.world, this.getPlayer.get());
                if (this.container instanceof ModWorkbenchContainer) {
                    ((ModWorkbenchContainer)this.container).rebindSlots();
                } else if (this.container instanceof MaintenanceKitContainer) {
                    ((MaintenanceKitContainer)this.container).updateSlots();
                }
            }
        }
    }

    public static class WithPredicate
    extends SlotItemHandler {
        final Predicate<ItemStack> predicate;
        final Consumer<ItemStack> onChange;

        public WithPredicate(IItemHandler inv, int id, int x, int y, Predicate<ItemStack> predicate) {
            this(inv, id, x, y, predicate, s -> {});
        }

        public WithPredicate(IItemHandler inv, int id, int x, int y, Predicate<ItemStack> predicate, Consumer<ItemStack> onChange) {
            super(inv, id, x, y);
            this.predicate = predicate;
            this.onChange = onChange;
        }

        public boolean m_5857_(ItemStack itemStack) {
            return !itemStack.m_41619_() && this.predicate.test(itemStack);
        }

        public int m_6641_() {
            return 1;
        }

        public void m_6654_() {
            super.m_6654_();
            this.onChange.accept(this.m_7993_());
        }
    }

    public static class Bullet
    extends SlotItemHandler {
        int limit;

        public Bullet(IItemHandler inv, int id, int x, int y, int limit) {
            super(inv, id, x, y);
            this.limit = limit;
        }

        public boolean m_5857_(ItemStack itemStack) {
            return !itemStack.m_41619_() && itemStack.m_41720_() instanceof BulletItem;
        }

        public int m_6641_() {
            return this.limit;
        }

        public int m_5866_(@Nonnull ItemStack stack) {
            return this.limit;
        }
    }

    public static class BlastFuel
    extends IESlot {
        private final Level level;

        public BlastFuel(AbstractContainerMenu container, Container inv, int id, int x, int y, Level level) {
            super(container, inv, id, x, y);
            this.level = level;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return BlastFurnaceFuel.isValidBlastFuel(this.level, itemStack);
        }
    }

    public static class FluidContainer
    extends IESlot {
        int filter;

        public FluidContainer(AbstractContainerMenu container, Container inv, int id, int x, int y, int filter) {
            super(container, inv, id, x, y);
            this.filter = filter;
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            LazyOptional handlerCap = FluidUtil.getFluidHandler((ItemStack)itemStack);
            return handlerCap.map(handler -> {
                if (handler.getTanks() <= 0) {
                    return false;
                }
                if (this.filter == 1) {
                    return handler.getFluidInTank(0).isEmpty();
                }
                if (this.filter == 2) {
                    return !handler.getFluidInTank(0).isEmpty();
                }
                return true;
            }).orElse(false);
        }
    }

    public static class IEFurnaceSFuelSlot
    extends IESlot {
        public IEFurnaceSFuelSlot(AbstractContainerMenu container, Container inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean m_5857_(ItemStack stack) {
            return AbstractFurnaceBlockEntity.m_58399_((ItemStack)stack) || IEFurnaceSFuelSlot.isBucket(stack);
        }

        public int m_5866_(ItemStack stack) {
            return IEFurnaceSFuelSlot.isBucket(stack) ? 1 : super.m_5866_(stack);
        }

        public static boolean isBucket(ItemStack stack) {
            return stack.m_41720_() == Items.f_42446_;
        }
    }

    public static class Output
    extends IESlot {
        public Output(AbstractContainerMenu container, Container inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean m_5857_(ItemStack itemStack) {
            return false;
        }
    }
}

