/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.common.blocks.metal.MixerBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

public class MixerRenderer
extends IEBlockEntityRenderer<MixerBlockEntity> {
    public static final String NAME = "mixer_agitator";
    public static DynamicModel AGITATOR;

    public void render(MixerBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.formed || te.isDummy() || !te.getLevelNonnull().m_46805_(te.m_58899_())) {
            return;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockPos blockPos = te.m_58899_();
        BlockState state = te.m_58904_().m_8055_(blockPos);
        if (state.m_60734_() != IEBlocks.Multiblocks.MIXER.get()) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        bufferIn = BERenderUtils.mirror(te, matrixStack, bufferIn);
        matrixStack.m_85836_();
        matrixStack.m_85837_(te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.WEST ? -0.5 : 0.5, 0.0, te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.EAST ? 0.5 : -0.5);
        float agitator = te.animation_agitator - (!te.shouldRenderAsActive() ? 0.0f : (1.0f - partialTicks) * 9.0f);
        matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), agitator, true));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        blockRenderer.m_110937_().renderModel(matrixStack.m_85850_(), bufferIn.m_6299_(RenderType.m_110451_()), state, AGITATOR.get(), 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.m_85849_();
        matrixStack.m_85837_(te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.WEST ? -0.5 : 0.5, -0.625, te.getFacing() == Direction.SOUTH || te.getFacing() == Direction.EAST ? 0.5 : -0.5);
        matrixStack.m_85841_(0.0625f, 1.0f, 0.0625f);
        matrixStack.m_85845_(new Quaternion(90.0f, 0.0f, 0.0f, true));
        for (int i = te.tank.getFluidTypes() - 1; i >= 0; --i) {
            FluidStack fs = te.tank.fluids.get(i);
            if (fs == null || fs.getFluid() == null) continue;
            float yy = (float)fs.getAmount() / (float)te.tank.getCapacity() * 1.0625f;
            matrixStack.m_85837_(0.0, 0.0, (double)(-yy));
            float w = i < te.tank.getFluidTypes() - 1 || (double)yy >= 0.125 ? 26.0f : 16.0f + yy / 0.0125f;
            GuiHelper.drawRepeatedFluidSprite(bufferIn.m_6299_(RenderType.m_110466_()), matrixStack, fs, -w / 2.0f, -w / 2.0f, w, w);
        }
        matrixStack.m_85849_();
    }
}

