/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.utils;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WireLink {
    public final ConnectionPoint cp;
    public final ResourceKey<Level> dimension;
    public final BlockPos offset;
    public final TargetingInfo target;

    public WireLink(ConnectionPoint cp, ResourceKey<Level> dimension, BlockPos offset, TargetingInfo info) {
        this.cp = cp;
        this.dimension = dimension;
        this.offset = offset.m_7949_();
        this.target = info;
    }

    public static WireLink create(ConnectionPoint cp, Level world, BlockPos offset, TargetingInfo info) {
        return new WireLink(cp, (ResourceKey<Level>)world.m_46472_(), offset, info);
    }

    public void writeToItem(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("linkingDim", this.dimension.m_135782_().toString());
        nbt.m_128365_("linkingPos", (Tag)this.cp.createTag());
        nbt.m_128365_("linkingOffset", (Tag)NbtUtils.m_129224_((BlockPos)this.offset));
        CompoundTag targetNBT = new CompoundTag();
        this.target.writeToNBT(targetNBT);
        nbt.m_128365_("linkingTarget", (Tag)targetNBT);
    }

    public static WireLink readFromItem(ItemStack stack) {
        CompoundTag nbt = stack.m_41782_() ? stack.m_41784_() : new CompoundTag();
        ConnectionPoint cp = new ConnectionPoint(nbt.m_128469_("linkingPos"));
        ResourceLocation dim = new ResourceLocation(nbt.m_128461_("linkingDim"));
        BlockPos offset = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("linkingOffset"));
        TargetingInfo info = TargetingInfo.readFromNBT(nbt.m_128469_("linkingTarget"));
        return new WireLink(cp, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dim), offset, info);
    }
}

