/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.IETags;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ToolboxHandler {
    private static final List<Predicate<ItemStack>> tools = new ArrayList<Predicate<ItemStack>>();
    private static final List<Predicate<ItemStack>> foods = new ArrayList<Predicate<ItemStack>>();
    private static final List<Predicate<ItemStack>> wiring = new ArrayList<Predicate<ItemStack>>();

    public static boolean isTool(ItemStack s) {
        for (Predicate<ItemStack> p : tools) {
            if (!p.test(s)) continue;
            return true;
        }
        return false;
    }

    public static void addToolType(Predicate<ItemStack> in) {
        tools.add(in);
    }

    public static boolean isFood(ItemStack s) {
        for (Predicate<ItemStack> p : foods) {
            if (!p.test(s)) continue;
            return true;
        }
        return false;
    }

    public static void addFoodType(Predicate<ItemStack> in) {
        foods.add(in);
    }

    public static boolean isWiring(ItemStack s) {
        for (Predicate<ItemStack> p : wiring) {
            if (!p.test(s)) continue;
            return true;
        }
        return false;
    }

    public static void addWiringType(Predicate<ItemStack> in) {
        wiring.add(in);
    }

    static {
        HashSet toolActions = Sets.newHashSet();
        toolActions.addAll(ToolActions.DEFAULT_PICKAXE_ACTIONS);
        toolActions.addAll(ToolActions.DEFAULT_AXE_ACTIONS);
        toolActions.addAll(ToolActions.DEFAULT_SHOVEL_ACTIONS);
        toolActions.addAll(ToolActions.DEFAULT_HOE_ACTIONS);
        toolActions.addAll(ToolActions.DEFAULT_SHEARS_ACTIONS);
        tools.add(s -> s.m_204117_(IETags.toolboxTools));
        tools.add(s -> {
            for (ToolAction action : toolActions) {
                if (!s.canPerformAction(action)) continue;
                return true;
            }
            return false;
        });
        foods.add(s -> s.m_41720_().m_41472_());
        foods.add(s -> s.m_204117_(IETags.toolboxFood));
        wiring.add(s -> s.m_204117_(IETags.toolboxWiring));
    }

    public static enum ToolboxCategory {
        FOOD(0, 2, ToolboxHandler::isFood),
        TOOL(3, 9, ToolboxHandler::isTool),
        WIRING(10, 15, ToolboxHandler::isWiring),
        ANY(16, 22, s -> true);

        final int[] slots;
        final Predicate<ItemStack> accepts;

        private ToolboxCategory(int from, int to, Predicate<ItemStack> accepts) {
            this.slots = IntStream.rangeClosed(from, to).toArray();
            this.accepts = accepts;
        }

        public int[] getSlots() {
            return this.slots;
        }

        public boolean accepts(ItemStack stack) {
            return this.accepts.test(stack);
        }
    }
}

