/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;

public class FluidTagInput
implements Predicate<FluidStack> {
    protected final Either<TagKey<Fluid>, List<ResourceLocation>> fluidTag;
    protected final int amount;
    protected final CompoundTag nbtTag;

    public FluidTagInput(Either<TagKey<Fluid>, List<ResourceLocation>> matching, int amount, CompoundTag nbtTag) {
        this.fluidTag = matching;
        this.amount = amount;
        this.nbtTag = nbtTag;
    }

    public FluidTagInput(TagKey<Fluid> fluidTag, int amount, CompoundTag nbtTag) {
        this((Either<TagKey<Fluid>, List<ResourceLocation>>)Either.left(fluidTag), amount, nbtTag);
    }

    public FluidTagInput(ResourceLocation resourceLocation, int amount, CompoundTag nbtTag) {
        this((TagKey<Fluid>)TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)resourceLocation), amount, nbtTag);
    }

    public FluidTagInput(ResourceLocation resourceLocation, int amount) {
        this(resourceLocation, amount, null);
    }

    public FluidTagInput(TagKey<Fluid> tag, int amount) {
        this(tag, amount, null);
    }

    public static FluidTagInput deserialize(JsonElement input) {
        Preconditions.checkArgument((boolean)(input instanceof JsonObject), (Object)"FluidTagWithSize can only be deserialized from a JsonObject");
        JsonObject jsonObject = input.getAsJsonObject();
        ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
        if (!GsonHelper.m_13900_((JsonObject)jsonObject, (String)"nbt")) {
            return new FluidTagInput(resourceLocation, GsonHelper.m_13927_((JsonObject)jsonObject, (String)"amount"));
        }
        try {
            CompoundTag nbt = ItemUtils.parseNbtFromJson(jsonObject.get("nbt"));
            return new FluidTagInput(resourceLocation, GsonHelper.m_13927_((JsonObject)jsonObject, (String)"amount"), nbt);
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public FluidTagInput withAmount(int amount) {
        return new FluidTagInput(this.fluidTag, amount, this.nbtTag);
    }

    @Override
    public boolean test(@Nullable FluidStack fluidStack) {
        return this.testIgnoringAmount(fluidStack) && fluidStack.getAmount() >= this.amount;
    }

    public boolean testIgnoringAmount(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        if (!((Boolean)this.fluidTag.map(t -> fluidStack.getFluid().m_205067_(t), l -> l.contains(fluidStack.getFluid().getRegistryName()))).booleanValue()) {
            return false;
        }
        if (this.nbtTag != null) {
            return fluidStack.hasTag() && fluidStack.getTag().equals((Object)this.nbtTag);
        }
        return true;
    }

    @Nonnull
    public List<FluidStack> getMatchingFluidStacks() {
        return ((Stream)this.fluidTag.map(t -> TagUtils.elementStream(Registry.f_122822_, t), l -> l.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0)))).map(fluid -> new FluidStack(fluid, this.amount, this.nbtTag)).collect(Collectors.toList());
    }

    @Nonnull
    public JsonElement serialize() {
        JsonObject jsonObject = new JsonObject();
        ResourceLocation name = ((TagKey)this.fluidTag.orThrow()).f_203868_();
        jsonObject.addProperty("tag", name.toString());
        jsonObject.addProperty("amount", (Number)this.amount);
        if (this.nbtTag != null) {
            jsonObject.addProperty("nbt", this.nbtTag.toString());
        }
        return jsonObject;
    }

    public int getAmount() {
        return this.amount;
    }

    public FluidStack getRandomizedExampleStack(int rand) {
        List<FluidStack> all = this.getMatchingFluidStacks();
        return all.get(rand / 20 % all.size());
    }

    public static FluidTagInput read(FriendlyByteBuf input) {
        int numMatching = input.m_130242_();
        ArrayList<ResourceLocation> matching = new ArrayList<ResourceLocation>(numMatching);
        for (int i = 0; i < numMatching; ++i) {
            matching.add(input.m_130281_());
        }
        int amount = input.readInt();
        CompoundTag nbt = input.readBoolean() ? input.m_130260_() : null;
        return new FluidTagInput((Either<TagKey<Fluid>, List<ResourceLocation>>)Either.right(matching), amount, nbt);
    }

    public void write(FriendlyByteBuf out) {
        List matching = (List)this.fluidTag.map(f -> TagUtils.elementStream(Registry.f_122822_, f).map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toList()), l -> l);
        out.m_130130_(matching.size());
        for (ResourceLocation rl : matching) {
            out.m_130085_(rl);
        }
        out.writeInt(this.amount);
        out.writeBoolean(this.nbtTag != null);
        if (this.nbtTag != null) {
            out.m_130079_(this.nbtTag);
        }
    }

    public boolean extractFrom(IFluidHandler handler, IFluidHandler.FluidAction action) {
        for (int tank = 0; tank < handler.getTanks(); ++tank) {
            FluidStack toExtract;
            FluidStack extractedSim;
            FluidStack inTank = handler.getFluidInTank(tank);
            if (!this.testIgnoringAmount(inTank) || (extractedSim = handler.drain(toExtract = FluidUtils.copyFluidStackWithAmount(inTank, this.amount), IFluidHandler.FluidAction.SIMULATE)).getAmount() < this.amount) continue;
            if (action != IFluidHandler.FluidAction.SIMULATE) {
                handler.drain(toExtract, action);
            }
            return true;
        }
        return false;
    }
}

