/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.ArcRecyclingChecker;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IECommonConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.crafting.IngredientSerializers;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipes;
import blusunrize.immersiveengineering.common.items.DrillheadItem;
import blusunrize.immersiveengineering.common.items.HammerItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.ScrewdriverItem;
import blusunrize.immersiveengineering.common.items.WirecutterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageBirthdayParty;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import blusunrize.immersiveengineering.common.network.MessageContainerData;
import blusunrize.immersiveengineering.common.network.MessageContainerUpdate;
import blusunrize.immersiveengineering.common.network.MessageMagnetEquip;
import blusunrize.immersiveengineering.common.network.MessageMaintenanceKit;
import blusunrize.immersiveengineering.common.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.network.MessageMultiblockSync;
import blusunrize.immersiveengineering.common.network.MessageNoSpamChatComponents;
import blusunrize.immersiveengineering.common.network.MessageObstructedConnection;
import blusunrize.immersiveengineering.common.network.MessageOpenManual;
import blusunrize.immersiveengineering.common.network.MessagePowerpackAntenna;
import blusunrize.immersiveengineering.common.network.MessageRedstoneLevel;
import blusunrize.immersiveengineering.common.network.MessageRequestEnergyUpdate;
import blusunrize.immersiveengineering.common.network.MessageRequestRedstoneUpdate;
import blusunrize.immersiveengineering.common.network.MessageRevolverRotate;
import blusunrize.immersiveengineering.common.network.MessageScrollwheelItem;
import blusunrize.immersiveengineering.common.network.MessageSetGhostSlots;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.immersiveengineering.common.network.MessageSkyhookSync;
import blusunrize.immersiveengineering.common.network.MessageSpeedloaderSync;
import blusunrize.immersiveengineering.common.network.MessageStoredEnergy;
import blusunrize.immersiveengineering.common.network.MessageWireSync;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IEIMCHandler;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.MissingMappingsHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.advancements.IEAdvancements;
import blusunrize.immersiveengineering.common.util.commands.CommandHandler;
import blusunrize.immersiveengineering.common.util.commands.CommandMineral;
import blusunrize.immersiveengineering.common.util.compat.IECompatModules;
import blusunrize.immersiveengineering.common.world.IEWorldGen;
import blusunrize.immersiveengineering.common.world.Villages;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonStreamParser;
import com.mojang.brigadier.CommandDispatcher;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;

@Mod(value="immersiveengineering")
public class ImmersiveEngineering {
    public static final String MODID = "immersiveengineering";
    public static final String MODNAME = "Immersive Engineering";
    public static final String VERSION = IEApi.getCurrentVersion();
    public static final CommonProxy proxy = (CommonProxy)DistExecutor.safeRunForDist(ImmersiveEngineering.bootstrapErrorToXCPInDev(() -> ClientProxy::new), ImmersiveEngineering.bootstrapErrorToXCPInDev(() -> CommonProxy::new));
    public static final SimpleChannel packetHandler = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("immersiveengineering", "main")).networkProtocolVersion(() -> VERSION).serverAcceptedVersions(VERSION::equals).clientAcceptedVersions(VERSION::equals).simpleChannel();
    private int messageId = 0;
    private final Set<Class<?>> knownPacketTypes = new HashSet();
    public static final CreativeModeTab ITEM_GROUP = new CreativeModeTab("immersiveengineering"){

        @Nonnull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER));
        }
    };

    public static <T> Supplier<T> bootstrapErrorToXCPInDev(Supplier<T> in) {
        if (FMLLoader.isProduction()) {
            return in;
        }
        return () -> {
            try {
                return in.get();
            }
            catch (BootstrapMethodError e) {
                throw new RuntimeException(e);
            }
        };
    }

    public ImmersiveEngineering() {
        IELogger.logger = LogManager.getLogger((String)MODID);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMCs);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addGenericListener(Block.class, MissingMappingsHelper::handleRemapping);
        MinecraftForge.EVENT_BUS.addGenericListener(Item.class, MissingMappingsHelper::handleRemapping);
        MinecraftForge.EVENT_BUS.addGenericListener(Fluid.class, MissingMappingsHelper::handleRemapping);
        RecipeSerializers.RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        Villages.Registers.POINTS_OF_INTEREST.register(FMLJavaModLoadingContext.get().getModEventBus());
        Villages.Registers.PROFESSIONS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)IECommonConfig.CONFIG_SPEC.getBaseSpec());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)IEClientConfig.CONFIG_SPEC.getBaseSpec());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)IEServerConfig.CONFIG_SPEC.getBaseSpec());
        IEContent.modConstruction();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, ImmersiveEngineering.bootstrapErrorToXCPInDev(() -> ClientProxy::modConstruction));
        IngredientSerializers.init();
        IEWorldGen ieWorldGen = new IEWorldGen();
        MinecraftForge.EVENT_BUS.register((Object)ieWorldGen);
        IEWorldGen.init();
        IECompatModules.onModConstruction();
    }

    public void setup(FMLCommonSetupEvent event) {
        IEAdvancements.preInit();
        IEApi.prefixToIngotMap.put("ingots", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("nuggets", new Integer[]{1, 9});
        IEApi.prefixToIngotMap.put("storage_blocks", new Integer[]{9, 1});
        IEApi.prefixToIngotMap.put("plates", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("wires", new Integer[]{1, 2});
        IEApi.prefixToIngotMap.put("gears", new Integer[]{4, 1});
        IEApi.prefixToIngotMap.put("rods", new Integer[]{1, 2});
        IEApi.prefixToIngotMap.put("fences", new Integer[]{5, 3});
        IEApi.prefixToIngotMap.put("cut_blocks", new Integer[]{9, 4});
        IEApi.prefixToIngotMap.put("cut_stairs", new Integer[]{9, 4});
        IEApi.prefixToIngotMap.put("cut_slabs", new Integer[]{9, 8});
        ArcRecyclingChecker.allowRecipeTypeForRecycling(RecipeType.f_44107_);
        ArcRecyclingChecker.allowRecipeTypeForRecycling(MetalPressRecipe.TYPE);
        ArcRecyclingChecker.allowSimpleItemForRecycling(stack -> stack instanceof DiggerItem || stack instanceof ShearsItem || stack instanceof SwordItem || stack instanceof ArmorItem || stack instanceof HorseArmorItem || stack instanceof BucketItem);
        ArcRecyclingChecker.allowSimpleItemForRecycling(stack -> stack instanceof HammerItem || stack instanceof WirecutterItem || stack instanceof ScrewdriverItem || stack instanceof DrillheadItem);
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> Stream.of(IEItems.Molds.MOLD_PLATE, IEItems.Molds.MOLD_GEAR, IEItems.Molds.MOLD_ROD, IEItems.Molds.MOLD_BULLET_CASING, IEItems.Molds.MOLD_WIRE, IEItems.Molds.MOLD_PACKING_4, IEItems.Molds.MOLD_PACKING_9, IEItems.Molds.MOLD_UNPACKING));
        ArcRecyclingChecker.allowItemTagForRecycling(IETags.plates);
        ArcRecyclingChecker.allowPrefixedTagForRecycling("rods/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("wires/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("gears/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("scaffoldings/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("scaffolding_stairs/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("scaffolding_slabs/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("fences/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("cut_blocks/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("cut_stairs/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("cut_slabs/");
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> Stream.of(IEBlocks.MetalDecoration.ENGINEERING_RS, IEBlocks.MetalDecoration.ENGINEERING_LIGHT, IEBlocks.MetalDecoration.ENGINEERING_HEAVY, IEBlocks.MetalDecoration.GENERATOR, IEBlocks.MetalDecoration.RADIATOR));
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> Stream.of(IEBlocks.MetalDecoration.ALU_WALLMOUNT, IEBlocks.MetalDecoration.STEEL_WALLMOUNT, IEBlocks.MetalDecoration.STEEL_SLOPE, IEBlocks.MetalDecoration.ALU_SLOPE, IEBlocks.MetalDecoration.ALU_POST, IEBlocks.MetalDecoration.STEEL_POST));
        for (EnumMetals metal : EnumMetals.values()) {
            ArcRecyclingChecker.allowItemTagForRecycling(IETags.getItemTag(IETags.getTagsFor((EnumMetals)metal).sheetmetal));
        }
        ArcRecyclingChecker.allowItemTagForRecycling(IETags.getItemTag(IETags.sheetmetalSlabs));
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> Stream.of(IEBlocks.MetalDevices.RAZOR_WIRE, IEBlocks.MetalDevices.BARREL, IEBlocks.MetalDevices.FLUID_PIPE));
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> IEBlocks.MetalDevices.CHUTES.values().stream());
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> Stream.of(Items.f_42151_, Items.f_42150_, Items.f_42128_, Items.f_42341_, Items.f_42025_, Items.f_42544_, Items.f_42449_, Items.f_42146_, Items.f_42147_, Items.f_42148_, Items.f_151041_));
        ArcRecyclingChecker.allowItemTagForRecycling(IETags.recyclingWhitelist);
        ArcRecyclingChecker.makeItemInvalidRecyclingOutput((tags, stack) -> stack.m_204117_(IETags.recyclingIgnoredComponents));
        new ThreadContributorSpecialsDownloader();
        IEContent.init((ParallelDispatchEvent)event);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        IECompatModules.onCommonSetup();
        this.registerMessage(MessageBlockEntitySync.class, MessageBlockEntitySync::new);
        this.registerMessage(MessageContainerUpdate.class, MessageContainerUpdate::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageSpeedloaderSync.class, MessageSpeedloaderSync::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageSkyhookSync.class, MessageSkyhookSync::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageMinecartShaderSync.class, MessageMinecartShaderSync::new);
        this.registerMessage(MessageRequestEnergyUpdate.class, MessageRequestEnergyUpdate::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageStoredEnergy.class, MessageStoredEnergy::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageRequestRedstoneUpdate.class, MessageRequestRedstoneUpdate::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageRedstoneLevel.class, MessageRedstoneLevel::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageNoSpamChatComponents.class, MessageNoSpamChatComponents::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageShaderManual.class, MessageShaderManual::new);
        this.registerMessage(MessageBirthdayParty.class, MessageBirthdayParty::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageMagnetEquip.class, MessageMagnetEquip::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageScrollwheelItem.class, MessageScrollwheelItem::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageObstructedConnection.class, MessageObstructedConnection::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageSetGhostSlots.class, MessageSetGhostSlots::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageWireSync.class, MessageWireSync::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageMaintenanceKit.class, MessageMaintenanceKit::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageRevolverRotate.class, MessageRevolverRotate::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageMultiblockSync.class, MessageMultiblockSync::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageContainerData.class, MessageContainerData::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageOpenManual.class, MessageOpenManual::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessagePowerpackAntenna.class, MessagePowerpackAntenna::new, NetworkDirection.PLAY_TO_CLIENT);
        IEIMCHandler.init();
        IEIMCHandler.handleIMCMessages(InterModComms.getMessages((String)MODID));
        CommandMineral.registerArguments();
        MetalPressPackingRecipes.init();
    }

    private <T extends IMessage> void registerMessage(Class<T> packetType, Function<FriendlyByteBuf, T> decoder) {
        this.registerMessage(packetType, decoder, Optional.empty());
    }

    private <T extends IMessage> void registerMessage(Class<T> packetType, Function<FriendlyByteBuf, T> decoder, NetworkDirection direction) {
        this.registerMessage(packetType, decoder, Optional.of(direction));
    }

    private <T extends IMessage> void registerMessage(Class<T> packetType, Function<FriendlyByteBuf, T> decoder, Optional<NetworkDirection> direction) {
        if (!this.knownPacketTypes.add(packetType)) {
            throw new IllegalStateException("Duplicate packet type: " + packetType.getName());
        }
        packetHandler.registerMessage(this.messageId++, packetType, IMessage::toBytes, decoder, (t, ctx) -> {
            t.process((Supplier<NetworkEvent.Context>)ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        }, direction);
    }

    public void enqueueIMCs(InterModEnqueueEvent event) {
        IECompatModules.doModulesIMCs();
    }

    public void registerCommands(RegisterCommandsEvent event) {
        CommandHandler.registerServer((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void serverStarted(ServerStartedEvent event) {
        ServerLevel world = event.getServer().m_129880_(Level.f_46428_);
        if (!world.f_46443_) {
            IESaveData worldData = (IESaveData)world.m_8895_().m_164861_(IESaveData::new, IESaveData::new, "ImmersiveEngineering-SaveData");
            IESaveData.setInstance(worldData);
        }
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static class ThreadContributorSpecialsDownloader
    extends Thread {
        public static ThreadContributorSpecialsDownloader activeThread;

        public ThreadContributorSpecialsDownloader() {
            this.setName("Immersive Engineering Contributors Thread");
            this.setDaemon(true);
            this.start();
            activeThread = this;
        }

        @Override
        public void run() {
            Gson gson = new Gson();
            try {
                IELogger.info("Attempting to download special revolvers from GitHub");
                URL url = new URL("https://raw.githubusercontent.com/BluSunrize/ImmersiveEngineering/gh-pages/contributorRevolvers.json");
                JsonStreamParser parser = new JsonStreamParser((Reader)new InputStreamReader(url.openStream()));
                while (parser.hasNext()) {
                    try {
                        JsonElement je = parser.next();
                        RevolverItem.SpecialRevolver revolver = (RevolverItem.SpecialRevolver)gson.fromJson(je, RevolverItem.SpecialRevolver.class);
                        if (revolver == null) continue;
                        if (revolver.uuid != null) {
                            for (String uuid : revolver.uuid) {
                                RevolverItem.specialRevolvers.put((Object)uuid, (Object)revolver);
                            }
                        }
                        RevolverItem.specialRevolversByTag.put(!revolver.tag.isEmpty() ? revolver.tag : revolver.flavour, revolver);
                    }
                    catch (Exception excepParse) {
                        IELogger.warn("Error on parsing a SpecialRevolver");
                    }
                }
            }
            catch (Exception e) {
                IELogger.logger.info("Could not load contributor+special revolver list.", (Throwable)e);
            }
        }
    }
}

