/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.items;

import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.entities.IRocketEntity;
import net.mrscauthd.beyond_earth.entities.RocketTier2Entity;
import net.mrscauthd.beyond_earth.events.ClientEventBusSubscriber;
import net.mrscauthd.beyond_earth.itemgroups.ItemGroups;
import net.mrscauthd.beyond_earth.items.FilledAltVehicleItem;
import net.mrscauthd.beyond_earth.items.IRocketItem;
import net.mrscauthd.beyond_earth.registries.EntitiesRegistry;

public class Tier2RocketItem
extends IRocketItem
implements FilledAltVehicleItem {
    public Tier2RocketItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockEntityWithoutLevelRenderer getRenderer() {
        return ClientEventBusSubscriber.ROCKET_TIER_2_ITEM_RENDERER;
    }

    @Override
    public EntityType getEntityType() {
        return (EntityType)EntitiesRegistry.TIER_2_ROCKET.get();
    }

    @Override
    public IRocketEntity getRocket(Level level) {
        return new RocketTier2Entity((EntityType)EntitiesRegistry.TIER_2_ROCKET.get(), level);
    }

    @Override
    public void fillItemCategoryAlt(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_41389_(p_41391_)) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            itemStack.m_41784_().m_128405_("beyond_earth:fuel", 300);
            p_41392_.add((Object)itemStack);
        }
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (p_41391_ != ItemGroups.tab_normal) {
            super.m_6787_(p_41391_, p_41392_);
        }
    }

    @Override
    public void itemCategoryAlt(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_41389_(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this));
        }
    }
}

