/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.gauge;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.mrscauthd.beyond_earth.gauge.AbstractGaugeDataRenderer;
import net.mrscauthd.beyond_earth.gauge.GaugeValueFluidStack;
import net.mrscauthd.beyond_earth.gauge.GaugeValueSerializer;
import net.mrscauthd.beyond_earth.gauge.GaugeValueSimple;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.guis.helper.GuiHelper;

public class GaugeValueRenderer
extends AbstractGaugeDataRenderer {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("beyond_earth", "textures/simplegaugevalue.png");

    public GaugeValueRenderer(IGaugeValue value) {
        super(value);
    }

    public GaugeValueRenderer(FriendlyByteBuf buffer) {
        super(GaugeValueSerializer.Serializer.read(buffer));
    }

    @Override
    public TextureAtlasSprite getBackgroundTileTexture() {
        IGaugeValue value = this.getValue();
        if (value instanceof GaugeValueFluidStack) {
            return GuiHelper.getStillFluidSprite(((GaugeValueFluidStack)value).getStack());
        }
        return null;
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        IGaugeValue value = this.getValue();
        return value instanceof GaugeValueSimple ? DEFAULT_TEXTURE : null;
    }
}

