/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.features;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import net.mrscauthd.beyond_earth.registries.BlocksRegistry;

public class VenusDeltas
extends Feature<ColumnFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.f_49991_, (Object)Blocks.f_50752_, (Object)Blocks.f_50450_, (Object)Blocks.f_50135_, (Object)Blocks.f_50197_, (Object)Blocks.f_50198_, (Object)Blocks.f_50199_, (Object)Blocks.f_50200_, (Object)Blocks.f_50087_, (Object)Blocks.f_50085_);
    private static final int CLUSTERED_REACH = 5;
    private static final int CLUSTERED_SIZE = 50;
    private static final int UNCLUSTERED_REACH = 8;
    private static final int UNCLUSTERED_SIZE = 15;

    public VenusDeltas(Codec<ColumnFeatureConfiguration> p_65153_) {
        super(p_65153_);
    }

    public boolean m_142674_(FeaturePlaceContext<ColumnFeatureConfiguration> p_159444_) {
        int i = p_159444_.m_159775_().m_6337_();
        BlockPos blockpos = p_159444_.m_159777_();
        WorldGenLevel worldgenlevel = p_159444_.m_159774_();
        Random random = p_159444_.m_159776_();
        ColumnFeatureConfiguration columnfeatureconfiguration = (ColumnFeatureConfiguration)p_159444_.m_159778_();
        if (!VenusDeltas.canPlaceAt((LevelAccessor)worldgenlevel, i, blockpos.m_122032_())) {
            return false;
        }
        int j = columnfeatureconfiguration.m_160720_().m_142270_(random);
        boolean flag = random.nextFloat() < 0.9f;
        int k = Math.min(j, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos blockpos1 : BlockPos.m_121957_((Random)random, (int)l, (int)(blockpos.m_123341_() - k), (int)blockpos.m_123342_(), (int)(blockpos.m_123343_() - k), (int)(blockpos.m_123341_() + k), (int)blockpos.m_123342_(), (int)(blockpos.m_123343_() + k))) {
            int i1 = j - blockpos1.m_123333_((Vec3i)blockpos);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn((LevelAccessor)worldgenlevel, i, blockpos1, i1, columnfeatureconfiguration.m_160717_().m_142270_(random));
        }
        return flag1;
    }

    private boolean placeColumn(LevelAccessor p_65168_, int p_65169_, BlockPos p_65170_, int p_65171_, int p_65172_) {
        boolean flag = false;
        block0: for (BlockPos blockpos : BlockPos.m_121976_((int)(p_65170_.m_123341_() - p_65172_), (int)p_65170_.m_123342_(), (int)(p_65170_.m_123343_() - p_65172_), (int)(p_65170_.m_123341_() + p_65172_), (int)p_65170_.m_123342_(), (int)(p_65170_.m_123343_() + p_65172_))) {
            int i = blockpos.m_123333_((Vec3i)p_65170_);
            BlockPos blockpos1 = VenusDeltas.isAirOrLavaOcean(p_65168_, p_65169_, blockpos) ? VenusDeltas.findSurface(p_65168_, p_65169_, blockpos.m_122032_(), i) : VenusDeltas.findAir(p_65168_, blockpos.m_122032_(), i);
            if (blockpos1 == null) continue;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = blockpos1.m_122032_();
            for (int j = p_65171_ - i / 2; j >= 0; --j) {
                if (VenusDeltas.isAirOrLavaOcean(p_65168_, p_65169_, (BlockPos)blockpos$mutableblockpos)) {
                    this.m_5974_((LevelWriter)p_65168_, (BlockPos)blockpos$mutableblockpos, ((Block)BlocksRegistry.INFERNAL_SPIRE_BLOCK.get()).m_49966_());
                    blockpos$mutableblockpos.m_122173_(Direction.UP);
                    flag = true;
                    continue;
                }
                if (!p_65168_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60713_((Block)BlocksRegistry.INFERNAL_SPIRE_BLOCK.get())) continue block0;
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            }
        }
        return flag;
    }

    @Nullable
    private static BlockPos findSurface(LevelAccessor p_65159_, int p_65160_, BlockPos.MutableBlockPos p_65161_, int p_65162_) {
        while (p_65161_.m_123342_() > p_65159_.m_141937_() + 1 && p_65162_ > 0) {
            --p_65162_;
            if (VenusDeltas.canPlaceAt(p_65159_, p_65160_, p_65161_)) {
                return p_65161_;
            }
            p_65161_.m_122173_(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor p_65155_, int p_65156_, BlockPos.MutableBlockPos p_65157_) {
        if (!VenusDeltas.isAirOrLavaOcean(p_65155_, p_65156_, (BlockPos)p_65157_)) {
            return false;
        }
        BlockState blockstate = p_65155_.m_8055_((BlockPos)p_65157_.m_122173_(Direction.DOWN));
        p_65157_.m_122173_(Direction.UP);
        return !blockstate.m_60795_() && !CANNOT_PLACE_ON.contains((Object)blockstate.m_60734_());
    }

    @Nullable
    private static BlockPos findAir(LevelAccessor p_65174_, BlockPos.MutableBlockPos p_65175_, int p_65176_) {
        while (p_65175_.m_123342_() < p_65174_.m_151558_() && p_65176_ > 0) {
            --p_65176_;
            BlockState blockstate = p_65174_.m_8055_((BlockPos)p_65175_);
            if (CANNOT_PLACE_ON.contains((Object)blockstate.m_60734_())) {
                return null;
            }
            if (blockstate.m_60795_()) {
                return p_65175_;
            }
            p_65175_.m_122173_(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(LevelAccessor p_65164_, int p_65165_, BlockPos p_65166_) {
        BlockState blockstate = p_65164_.m_8055_(p_65166_);
        return blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49991_) && p_65166_.m_123342_() <= p_65165_;
    }
}

