/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.armors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.mrscauthd.beyond_earth.armormaterials.NetheriteSpaceSuitMaterial;
import net.mrscauthd.beyond_earth.capabilities.oxygen.CapabilityOxygen;
import net.mrscauthd.beyond_earth.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.capabilities.oxygen.OxygenUtil;
import net.mrscauthd.beyond_earth.capabilities.oxygen.SpaceSuitCapabilityProvider;
import net.mrscauthd.beyond_earth.entities.renderer.spacesuit.SpaceSuitModel;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.itemgroups.ItemGroups;
import net.mrscauthd.beyond_earth.items.FilledAltArmorItem;
import org.jetbrains.annotations.Nullable;

public class NetheriteSpaceSuit {
    public static ArmorItem NETHERITE_OXYGEN_MASK = new FilledAltArmorItem(NetheriteSpaceSuitMaterial.ARMOR_MATERIAL, EquipmentSlot.HEAD, new Item.Properties().m_41491_(ItemGroups.tab_normal).m_41486_()){

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(new IItemRenderProperties(){

                public HumanoidModel getBaseArmorModel(LivingEntity living, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> defaultModel) {
                    Map<String, ModelPart> map = Map.of("head", new SpaceSuitModel.SPACE_SUIT_P1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SPACE_SUIT_P1.LAYER_LOCATION)).f_102808_, "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    SpaceSuitModel.SPACE_SUIT_P1 armorModel = new SpaceSuitModel.SPACE_SUIT_P1(modelPart);
                    armorModel.entity = living;
                    return armorModel;
                }
            });
        }

        @Override
        public void itemCategoryAlt(CreativeModeTab tab, NonNullList<ItemStack> list) {
            if (this.m_41389_(tab)) {
                list.add((Object)new ItemStack((ItemLike)this));
            }
        }

        public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
            if (p_41391_ != ItemGroups.tab_normal) {
                super.m_6787_(p_41391_, p_41392_);
            }
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/models/armor/netherite_space_suit_head.png";
        }
    };
    public static ArmorItem NETHERITE_SPACE_SUIT = new FilledAltArmorItem(NetheriteSpaceSuitMaterial.ARMOR_MATERIAL, EquipmentSlot.CHEST, new Item.Properties().m_41491_(ItemGroups.tab_normal).m_41486_()){

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(new IItemRenderProperties(){

                public HumanoidModel getBaseArmorModel(LivingEntity living, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> defaultModel) {
                    Map<String, ModelPart> map = Map.of("body", new SpaceSuitModel.SPACE_SUIT_P1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SPACE_SUIT_P1.LAYER_LOCATION)).f_102810_, "right_arm", new SpaceSuitModel.SPACE_SUIT_P1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SPACE_SUIT_P1.LAYER_LOCATION)).f_102811_, "left_arm", new SpaceSuitModel.SPACE_SUIT_P1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SPACE_SUIT_P1.LAYER_LOCATION)).f_102812_, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    SpaceSuitModel.SPACE_SUIT_P1 armorModel = new SpaceSuitModel.SPACE_SUIT_P1(modelPart);
                    armorModel.entity = living;
                    return armorModel;
                }
            });
        }

        @Override
        public void fillItemCategoryAlt(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
            ItemStack full;
            IOxygenStorage oxygenStorage;
            if (this.m_41389_(p_41391_) && (oxygenStorage = (IOxygenStorage)(full = new ItemStack((ItemLike)this)).getCapability(CapabilityOxygen.OXYGEN).orElse(null)) != null) {
                oxygenStorage.setOxygenStored(oxygenStorage.getMaxOxygenStored());
                p_41392_.add((Object)full);
            }
        }

        public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
            if (p_41391_ != ItemGroups.tab_normal) {
                super.m_6787_(p_41391_, p_41392_);
            }
        }

        @Override
        public void itemCategoryAlt(CreativeModeTab tab, NonNullList<ItemStack> list) {
            if (this.m_41389_(tab)) {
                list.add((Object)new ItemStack((ItemLike)this));
            }
        }

        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
            return new SpaceSuitCapabilityProvider(stack, 48000);
        }

        public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
            super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
            IOxygenStorage oxygenStorage = OxygenUtil.getItemStackOxygenStorage(p_41421_);
            p_41423_.add((Component)GaugeTextHelper.buildSpacesuitOxygenTooltip(oxygenStorage));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/models/armor/netherite_space_suit.png";
        }

        public void onArmorTick(ItemStack stack, Level world, Player player) {
            Methods.extractArmorOxygenUsingTimer(stack, player);
        }
    };
    public static ArmorItem NETHERITE_SPACE_PANTS = new FilledAltArmorItem(NetheriteSpaceSuitMaterial.ARMOR_MATERIAL, EquipmentSlot.LEGS, new Item.Properties().m_41491_(ItemGroups.tab_normal).m_41486_()){

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(new IItemRenderProperties(){

                public HumanoidModel getBaseArmorModel(LivingEntity living, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> defaultModel) {
                    Map<String, ModelPart> map = Map.of("right_leg", new SpaceSuitModel.SPACE_SUIT_P2<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SPACE_SUIT_P2.LAYER_LOCATION)).f_102813_, "left_leg", new SpaceSuitModel.SPACE_SUIT_P2<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SPACE_SUIT_P2.LAYER_LOCATION)).f_102814_, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    SpaceSuitModel.SPACE_SUIT_P2 armorModel = new SpaceSuitModel.SPACE_SUIT_P2(modelPart);
                    armorModel.entity = living;
                    return armorModel;
                }
            });
        }

        @Override
        public void itemCategoryAlt(CreativeModeTab tab, NonNullList<ItemStack> list) {
            if (this.m_41389_(tab)) {
                list.add((Object)new ItemStack((ItemLike)this));
            }
        }

        public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
            if (p_41391_ != ItemGroups.tab_normal) {
                super.m_6787_(p_41391_, p_41392_);
            }
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/models/armor/netherite_space_suit_legs.png";
        }
    };
    public static ArmorItem NETHERITE_SPACE_BOOTS = new FilledAltArmorItem(NetheriteSpaceSuitMaterial.ARMOR_MATERIAL, EquipmentSlot.FEET, new Item.Properties().m_41491_(ItemGroups.tab_normal).m_41486_()){

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(new IItemRenderProperties(){

                public HumanoidModel getBaseArmorModel(LivingEntity living, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> defaultModel) {
                    Map<String, ModelPart> map = Map.of("right_leg", new SpaceSuitModel.SPACE_SUIT_P1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SPACE_SUIT_P1.LAYER_LOCATION)).f_102813_, "left_leg", new SpaceSuitModel.SPACE_SUIT_P1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SPACE_SUIT_P1.LAYER_LOCATION)).f_102814_, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    SpaceSuitModel.SPACE_SUIT_P1 armorModel = new SpaceSuitModel.SPACE_SUIT_P1(modelPart);
                    armorModel.entity = living;
                    return armorModel;
                }
            });
        }

        @Override
        public void itemCategoryAlt(CreativeModeTab tab, NonNullList<ItemStack> list) {
            if (this.m_41389_(tab)) {
                list.add((Object)new ItemStack((ItemLike)this));
            }
        }

        public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
            if (p_41391_ != ItemGroups.tab_normal) {
                super.m_6787_(p_41391_, p_41392_);
            }
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/models/armor/netherite_space_suit.png";
        }
    };
}

