/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen;

import com.google.common.collect.ImmutableList;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.GaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.NumberInput;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.Picture;
import it.zerono.mods.zerocore.lib.client.gui.control.Static;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchButton;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.databind.BindingGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.IBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MonoConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MultiConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.client.text.BindableTextComponent;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.NonNullSupplier;

public class TurbineControllerScreen
extends AbstractMultiblockScreen<MultiblockTurbine, TurbineControllerEntity, ModTileContainer<TurbineControllerEntity>> {
    private static final int VBARPANEL_WIDTH = 18;
    private static final int VBARPANEL_HEIGHT = 84;
    private static final int INFOPANEL_WIDTH = 88;
    private static final Component TEXT_EMPTY = new TranslatableComponent("gui.bigreactors.generic.empty").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
    private static final Component TEXT_INDUCTOR_ENGAGED = new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.mode.engaged").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
    private static final Component TEXT_INDUCTOR_DISENGAGED = new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.mode.disengaged").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
    private static final Component TEXT_ROTOR_EFFICIENCY_100 = new TranslatableComponent("gui.bigreactors.turbine.controller.rotorstatus.100").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
    private final MultiblockTurbine _turbine = (MultiblockTurbine)this.getMultiblockController().orElseThrow(IllegalStateException::new);
    private final EnergySystem _outputEnergySystem = this._turbine.getOutputEnergySystem();
    private final double _turbineEnergyCapacity = this._turbine.getCapacity(this._outputEnergySystem).doubleValue();
    private final BindingGroup _bindings = new BindingGroup();
    private final GaugeBar _coolantBar = this.liquidBar("coolantBar", this._turbine.getFluidContainer().getCapacity());
    private final GaugeBar _vaporBar = this.liquidBar("vaporBar", this._turbine.getFluidContainer().getCapacity());
    private final GaugeBar _rpmBar;
    private final GaugeBar _energyBar = new GaugeBar((ModContainerScreen)this, "energyBar", this._turbineEnergyCapacity, CommonIcons.PowerBar.get());
    private final NumberInput.IntNumberInput _maxIntakeRate;
    private final SwitchPictureButton _inductorEngaged;
    private final SwitchPictureButton _ventAll;
    private final SwitchPictureButton _ventOverflow;
    private final SwitchPictureButton _ventDoNotVent;
    private final Label _lblEnergyRatio = this.infoLabel("energyRatioValue", "");
    private final Label _lblRpm;
    private final Label _lblRotorStatus;

    public TurbineControllerScreen(ModTileContainer<TurbineControllerEntity> container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, TurbineControllerScreen.mainTextureFromVariant((IMultiblockVariant)((TurbineControllerEntity)container.getTileEntity()).getMultiblockVariant().orElse(TurbineVariant.Basic)));
        this._rpmBar = new GaugeBar((ModContainerScreen)this, "rpmBar", (double)this._turbine.getVariant().getMaxRotorSpeed(), CommonIcons.RpmBar.get());
        this._lblRpm = this.infoLabel("rpmInfo", "");
        this._lblRotorStatus = this.infoLabel("rotorBlades", "");
        this._maxIntakeRate = new NumberInput.IntNumberInput((ModContainerScreen)this, "maxIntakeRate", 0, this._turbine.getMaxIntakeRateHardLimit(), this._turbine.getMaxIntakeRate());
        this._inductorEngaged = new SwitchPictureButton((ModContainerScreen)this, "inductorEngaged", false);
        this._ventAll = this.ventButton(VentSetting.VentAll);
        this._ventOverflow = this.ventButton(VentSetting.VentOverflow);
        this._ventDoNotVent = this.ventButton(VentSetting.DoNotVent);
    }

    public boolean m_6913_() {
        return true;
    }

    @Override
    protected void onScreenCreate() {
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, ExtremeReactors.newID("turbine/part-controller"), 1);
        Panel outerPanel = new Panel((ModContainerScreen)this);
        Panel barsPanel = new Panel((ModContainerScreen)this);
        Panel infoPanel = new Panel((ModContainerScreen)this);
        Panel infoPanelLeft = this.hInfoPanel();
        Panel infoPanelRight = this.hInfoPanel();
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setVerticalMargin(1)).setHorizontalMargin(13)).setControlsSpacing(0));
        outerPanel.setDesiredDimension(this.getGuiWidth() - 26, 141);
        outerPanel.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(2)).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        this.addControl((IControl)outerPanel);
        barsPanel.setDesiredDimension(DesiredDimension.Height, 84);
        barsPanel.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setZeroMargins()).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        outerPanel.addControl((IControl)barsPanel);
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(this.getGuiWidth() - 29, 1);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        Static s = new Static((ModContainerScreen)this, 0, 0).setColor(Colour.BLACK);
        s.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)0, (int)(this.getGuiWidth() - 29 - 3), (int)1));
        p.addControl((IControl)s);
        outerPanel.addControl((IControl)p);
        infoPanel.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setZeroMargins()).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        infoPanel.addControl(new IControl[]{infoPanelLeft, infoPanelRight});
        outerPanel.addControl((IControl)infoPanel);
        BindableTextComponent tankCapacity = new BindableTextComponent(capacity -> new TextComponent(CodeHelper.formatAsHumanReadableNumber((long)(capacity / 1000), (String)"B")).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        this.addBinding((MultiblockTurbine turbine) -> turbine.getFluidContainer().getCapacity(), new Consumer[]{v -> {
            this._coolantBar.setMaxValue((double)v.intValue());
            this._vaporBar.setMaxValue((double)v.intValue());
        }, tankCapacity});
        BindableTextComponent vaporFluidName = new BindableTextComponent(name -> name);
        BindableTextComponent vaporAmount = new BindableTextComponent(amount -> new TextComponent(CodeHelper.formatAsHumanReadableNumber((long)(amount / 1000), (String)"B")).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        BindableTextComponent vaporStoredPercentage = new BindableTextComponent(percentage -> new TextComponent(String.format("%d", (int)(percentage * 100.0))).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        p = this.vBarPanel();
        this.addBarIcon(CommonIcons.VaporIcon, p).useTooltipsFrom((IControl)this._vaporBar);
        this._vaporBar.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vaporbar.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vaporbar.line2").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vaporbar.line3a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)new TranslatableComponent("gui.bigreactors.turbine.controller.vaporbar.line3b")), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vaporbar.line4a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)new TranslatableComponent("gui.bigreactors.turbine.controller.vaporbar.line4b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vaporbar.line5"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vaporbar.line6"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vaporbar.line7")), (List)ImmutableList.of((Object)vaporFluidName, (Object)vaporAmount, (Object)tankCapacity, (Object)vaporStoredPercentage));
        this.addBinding((MultiblockTurbine turbine) -> TurbineControllerScreen.getFluidName(turbine.getFluidContainer().getGas()), new Consumer[]{v -> {
            this._vaporBar.setBarSprite(Sprite.EMPTY);
            this._vaporBar.setBarSpriteTint(Colour.WHITE);
            this._turbine.getFluidContainer().getGas().ifPresent(fluid -> {
                this._vaporBar.setBarSprite(ModRenderHelper.getFlowingFluidSprite((Fluid)fluid));
                this._vaporBar.setBarSpriteTint(Colour.fromARGB((int)fluid.getAttributes().getColor()));
            });
        }, vaporFluidName});
        Consumer[] consumerArray = new Consumer[2];
        consumerArray[0] = arg_0 -> ((GaugeBar)this._vaporBar).setValue(arg_0);
        consumerArray[1] = vaporAmount;
        this.addBinding((MultiblockTurbine turbine) -> turbine.getFluidContainer().getGasAmount(), consumerArray);
        this.addBinding((MultiblockTurbine turbine) -> turbine.getFluidContainer().getGasStoredPercentage(), new Consumer[]{v -> {}, vaporStoredPercentage});
        p.addControl((IControl)this._vaporBar);
        barsPanel.addControl((IControl)p);
        barsPanel.addControl((IControl)this.vTempScalePanel());
        BindableTextComponent coolantFluidName = new BindableTextComponent(name -> name);
        BindableTextComponent coolantAmount = new BindableTextComponent(amount -> new TextComponent(CodeHelper.formatAsHumanReadableNumber((long)(amount / 1000), (String)"B")).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        BindableTextComponent coolantStoredPercentage = new BindableTextComponent(percentage -> new TextComponent(String.format("%d", (int)(percentage * 100.0))).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        p = this.vBarPanel();
        this.addBarIcon(CommonIcons.CoolantIcon, p).useTooltipsFrom((IControl)this._coolantBar);
        this._coolantBar.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.turbine.controller.coolantbar.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.coolantbar.line2").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.coolantbar.line3a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)new TranslatableComponent("gui.bigreactors.turbine.controller.coolantbar.line3b")), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.coolantbar.line4a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)new TranslatableComponent("gui.bigreactors.turbine.controller.coolantbar.line4b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.coolantbar.line5"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.coolantbar.line6"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.coolantbar.line7"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.coolantbar.line8")), (List)ImmutableList.of((Object)coolantFluidName, (Object)coolantAmount, (Object)tankCapacity, (Object)coolantStoredPercentage));
        this.addBinding((MultiblockTurbine turbine) -> TurbineControllerScreen.getFluidName(turbine.getFluidContainer().getLiquid()), new Consumer[]{v -> {
            this._coolantBar.setBarSprite(Sprite.EMPTY);
            this._coolantBar.setBarSpriteTint(Colour.WHITE);
            this._turbine.getFluidContainer().getLiquid().ifPresent(fluid -> {
                this._coolantBar.setBarSprite(ModRenderHelper.getFlowingFluidSprite((Fluid)fluid));
                this._coolantBar.setBarSpriteTint(Colour.fromARGB((int)fluid.getAttributes().getColor()));
            });
        }, coolantFluidName});
        Consumer[] consumerArray2 = new Consumer[2];
        consumerArray2[0] = arg_0 -> ((GaugeBar)this._coolantBar).setValue(arg_0);
        consumerArray2[1] = coolantAmount;
        this.addBinding((MultiblockTurbine turbine) -> turbine.getFluidContainer().getLiquidAmount(), consumerArray2);
        this.addBinding((MultiblockTurbine turbine) -> turbine.getFluidContainer().getLiquidStoredPercentage(), new Consumer[]{v -> {}, coolantStoredPercentage});
        p.addControl((IControl)this._coolantBar);
        barsPanel.addControl((IControl)p);
        p = this.hInfoPanelSlot();
        p.addControl((IControl)new Label((ModContainerScreen)this, "maxIntakeLabel", (Component)new TranslatableComponent("gui.bigreactors.turbine.controller.maxintake.label")));
        infoPanelLeft.addControl((IControl)p);
        p = this.hInfoPanelSlot();
        this._maxIntakeRate.setStep(1, 10);
        this._maxIntakeRate.setDisplaySuffix(" mB/t");
        this._maxIntakeRate.setHorizontalAlignment(HorizontalAlignment.Right);
        this._maxIntakeRate.setDesiredDimension(78, 14);
        this._maxIntakeRate.Changed.subscribe(this::onMaxIntakeRateChanged);
        this._maxIntakeRate.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line2"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line3"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line4"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line5"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line6"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line7"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line8"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line9"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line10"), (Object[])new Component[]{new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line11"), new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line12"), new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line13"), new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line14"), new TranslatableComponent("gui.bigreactors.turbine.controlrod.maxintake.input.tooltip.line15")}));
        p.addControl((IControl)this._maxIntakeRate);
        infoPanelLeft.addControl((IControl)p);
        barsPanel.addControl((IControl)this.vSeparatorPanel());
        BindableTextComponent rpmText = new BindableTextComponent(rpm -> new TextComponent(String.format("%.2f RPM", rpm)).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        p = this.vBarPanel();
        this.addBarIcon(CommonIcons.RotorRPM, 16, 16, p).useTooltipsFrom((IControl)this._rpmBar);
        this._rpmBar.setDesiredDimension(18, 66);
        this._rpmBar.setBackground(CommonIcons.BarBackground.get());
        this._rpmBar.setPadding(1);
        this._rpmBar.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rpmbar.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rpmbar.line2").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rpmbar.line3"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rpmbar.line4"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rpmbar.line5"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rpmbar.line6"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rpmbar.line7"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rpmbar.line8")), (List)ImmutableList.of((Object)rpmText));
        this.addBinding((Function<MultiblockTurbine, Value>)((Function<MultiblockTurbine, Integer>)MultiblockTurbine::getMaxIntakeRate), (Consumer<Value>)((Consumer<Integer>)arg_0 -> ((NumberInput.IntNumberInput)this._maxIntakeRate).setValue(arg_0)));
        p.addControl((IControl)this._rpmBar);
        barsPanel.addControl((IControl)p);
        p = this.hInfoPanelSlot();
        Picture c = new Picture((ModContainerScreen)this, "rpmInfoIcon", CommonIcons.RotorRPM.get(), 16, 16);
        c.useTooltipsFrom((IControl)this._lblRpm);
        p.addControl((IControl)c);
        this._lblRpm.setTooltips(this._rpmBar.getTooltips(), this._rpmBar.getTooltipsObjects());
        this.addBinding(MultiblockTurbine::getRotorSpeed, new Consumer[]{rpm -> {
            this._lblRpm.setText(String.format("%.2f RPM", rpm));
            this._rpmBar.setValue((double)rpm.floatValue());
        }, rpmText});
        p.addControl((IControl)this._lblRpm);
        infoPanelRight.addControl((IControl)p);
        p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(11, 84);
        barsPanel.addControl((IControl)p);
        p = this.vBarPanel();
        this.addBarIcon(CommonIcons.PowerBattery, 16, 16, p).useTooltipsFrom((IControl)this._energyBar);
        BindableTextComponent energyStoredText = new BindableTextComponent(stored -> new TextComponent(CodeHelper.formatAsHumanReadableNumber((double)stored, (String)this._outputEnergySystem.getUnit())).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        BindableTextComponent energyStoredPercentageText = new BindableTextComponent(percentage -> new TextComponent(String.format("%d", (int)(percentage * 100.0))).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        this._energyBar.setDesiredDimension(18, 66);
        this._energyBar.setBackground(CommonIcons.BarBackground.get());
        this._energyBar.setPadding(1);
        this._energyBar.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.reactor.controller.energybar.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.energybar.line2a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)new TranslatableComponent("gui.bigreactors.reactor.controller.energybar.line2b", new Object[]{CodeHelper.formatAsHumanReadableNumber((double)this._turbineEnergyCapacity, (String)this._outputEnergySystem.getUnit())})), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.energybar.line3a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)new TranslatableComponent("gui.bigreactors.reactor.controller.energybar.line3b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.energybar.line4"), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.energybar.line5"), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.energybar.line6"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.energybar.line7"), (Object)new TranslatableComponent("gui.bigreactors.reactor.controller.energybar.line8")), (List)ImmutableList.of((Object)energyStoredText, (Object)energyStoredPercentageText));
        Consumer[] consumerArray3 = new Consumer[2];
        consumerArray3[0] = arg_0 -> ((GaugeBar)this._energyBar).setValue(arg_0);
        consumerArray3[1] = energyStoredText;
        this.addBinding((MultiblockTurbine turbine) -> turbine.getEnergyStored(EnergySystem.REFERENCE).doubleValue(), consumerArray3);
        this.addBinding((Function<MultiblockTurbine, Value>)((Function<MultiblockTurbine, Double>)AbstractGeneratorMultiblockController::getEnergyStoredPercentage), (Consumer<Value>)((Consumer)energyStoredPercentageText));
        p.addControl((IControl)this._energyBar);
        barsPanel.addControl((IControl)p);
        BindableTextComponent energyGeneratedText = new BindableTextComponent(generated -> new TextComponent(String.format("%.2f %s", generated, this._outputEnergySystem.getUnit())).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        p = this.hInfoPanelSlot();
        c = new Picture((ModContainerScreen)this, "energyRatio", CommonIcons.EnergyRatioIcon.get(), 16, 16);
        c.useTooltipsFrom((IControl)this._lblEnergyRatio);
        p.addControl((IControl)c);
        this._lblEnergyRatio.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.turbine.controller.energyratio.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.energyratio.line2a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)new TranslatableComponent("gui.bigreactors.turbine.controller.energyratio.line2b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.energyratio.line3"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.energyratio.line4"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.energyratio.line5"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.energyratio.line6"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.energyratio.line7")), (List)ImmutableList.of((Object)energyGeneratedText));
        this.addBinding(MultiblockTurbine::getEnergyGeneratedLastTick, new Consumer[]{value -> this._lblEnergyRatio.setText(CodeHelper.formatAsHumanReadableNumber((double)value, (String)(this._outputEnergySystem.getUnit() + "/t"))), energyGeneratedText});
        p.addControl((IControl)this._lblEnergyRatio);
        infoPanelRight.addControl((IControl)p);
        BindableTextComponent rotorEfficiencyText = new BindableTextComponent(text -> new TextComponent(text).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        BindableTextComponent rotorBlades = new BindableTextComponent(text -> new TextComponent(text).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        p = this.hInfoPanelSlot();
        c = new Picture((ModContainerScreen)this, "rotorStatusIcon", CommonIcons.RotorStatus.get(), 16, 16);
        c.useTooltipsFrom((IControl)this._lblRotorStatus);
        p.addControl((IControl)c);
        this._lblRotorStatus.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rotorstatus.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rotorstatus.line2"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rotorstatus.line3", new Object[]{String.format(ChatFormatting.DARK_AQUA + ChatFormatting.BOLD + "%d", this._turbine.getVariant().getBaseFluidPerBlade())}), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rotorstatus.line4"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rotorstatus.line5"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rotorstatus.line6"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rotorstatus.line7"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rotorstatus.line8"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.rotorstatus.line9"), (Object[])new Component[0]), (List)ImmutableList.of((Object)rotorEfficiencyText, (Object)rotorBlades));
        Consumer[] consumerArray4 = new Consumer[2];
        consumerArray4[0] = arg_0 -> ((Label)this._lblRotorStatus).setText(arg_0);
        consumerArray4[1] = rotorEfficiencyText;
        this.addBinding(TurbineControllerScreen::getRotorEfficiencyText, consumerArray4);
        this.addBinding((Function<MultiblockTurbine, Value>)((Function<MultiblockTurbine, String>)TurbineControllerScreen::getRotorBladesText), (Consumer<Value>)((Consumer)rotorBlades));
        p.addControl((IControl)this._lblRotorStatus);
        infoPanelRight.addControl((IControl)p);
        barsPanel.addControl((IControl)this.vSeparatorPanel());
        Panel commandPanel = this.vCommandPanel();
        barsPanel.addControl((IControl)commandPanel);
        int x = 0;
        int y = 0;
        int w = 38;
        SwitchButton on = new SwitchButton((ModContainerScreen)this, "on", "ON", false, "onoff");
        SwitchButton off = new SwitchButton((ModContainerScreen)this, "off", "OFF", true, "onoff");
        on.setLayoutEngineHint(FixedLayoutEngine.hint((int)x, (int)y, (int)w, (int)16));
        on.setTooltips(new Component[]{new TranslatableComponent("gui.bigreactors.turbine.controller.on.line1")});
        on.Activated.subscribe(this::onActiveStateChanged);
        on.Deactivated.subscribe(this::onActiveStateChanged);
        this.addBinding((Function<MultiblockTurbine, Value>)((Function<MultiblockTurbine, Boolean>)MultiblockTurbine::isMachineActive), (Consumer<Value>)((Consumer<Boolean>)arg_0 -> ((SwitchButton)on).setActive(arg_0)));
        off.setLayoutEngineHint(FixedLayoutEngine.hint((int)(x + w), (int)y, (int)w, (int)16));
        off.setTooltips(new Component[]{new TranslatableComponent("gui.bigreactors.turbine.controller.off.line1")});
        this.addBinding((Function<MultiblockTurbine, Value>)((Function<MultiblockTurbine, Boolean>)MultiblockTurbine::isMachineActive), (Consumer<Value>)((Consumer<Boolean>)active -> off.setActive(active == false)));
        commandPanel.addControl(new IControl[]{on, off});
        int xButton = x;
        BindableTextComponent inductorEngagedText = new BindableTextComponent(engaged -> engaged != false ? TEXT_INDUCTOR_ENGAGED : TEXT_INDUCTOR_DISENGAGED);
        this._inductorEngaged.setLayoutEngineHint(FixedLayoutEngine.hint((int)xButton, (int)(y += 28), (int)18, (int)18));
        this._inductorEngaged.Activated.subscribe(this::onInductorEngagedChanged);
        this._inductorEngaged.Deactivated.subscribe(this::onInductorEngagedChanged);
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._inductorEngaged, ButtonState.Default, CommonIcons.ButtonInductor);
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._inductorEngaged, ButtonState.Active, CommonIcons.ButtonInductorActive);
        this._inductorEngaged.setBackground(CommonIcons.ImageButtonBackground.get());
        this._inductorEngaged.enablePaintBlending(true);
        this._inductorEngaged.setPadding(1);
        this._inductorEngaged.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line2").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line3"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line4"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line5"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line6"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line7"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line8"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line9"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object[])new Component[]{new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line10"), new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line11"), new TranslatableComponent("gui.bigreactors.turbine.controller.inductor.line12")}), (List)ImmutableList.of((Object)inductorEngagedText));
        Consumer[] consumerArray5 = new Consumer[2];
        consumerArray5[0] = arg_0 -> ((SwitchPictureButton)this._inductorEngaged).setActive(arg_0);
        consumerArray5[1] = inductorEngagedText;
        this.addBinding(MultiblockTurbine::isInductorEngaged, consumerArray5);
        commandPanel.addControl((IControl)this._inductorEngaged);
        this._ventAll.setLayoutEngineHint(FixedLayoutEngine.hint((int)(xButton += 20), (int)y, (int)18, (int)18));
        this._ventAll.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.all.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.all.line2"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.all.line3"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.all.line4")));
        commandPanel.addControl((IControl)this._ventAll);
        this._ventOverflow.setLayoutEngineHint(FixedLayoutEngine.hint((int)(xButton += 19), (int)y, (int)18, (int)18));
        this._ventOverflow.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.overflow.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.overflow.line2"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.overflow.line3"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.overflow.line4")));
        commandPanel.addControl((IControl)this._ventOverflow);
        this._ventDoNotVent.setLayoutEngineHint(FixedLayoutEngine.hint((int)(xButton += 19), (int)y, (int)18, (int)18));
        this._ventDoNotVent.setTooltips((List)ImmutableList.of((Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.donotvent.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.donotvent.line2"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.donotvent.line3"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.donotvent.line4"), (Object)new TranslatableComponent("gui.bigreactors.turbine.controller.vent.donotvent.line5")));
        commandPanel.addControl((IControl)this._ventDoNotVent);
        this.addBinding((Function<MultiblockTurbine, Value>)((Function<MultiblockTurbine, VentSetting>)MultiblockTurbine::getVentSetting), (Consumer<Value>)((Consumer<VentSetting>)setting -> {
            this._ventAll.setActive(VentSetting.VentAll.test((VentSetting)setting));
            this._ventOverflow.setActive(VentSetting.VentOverflow.test((VentSetting)setting));
            this._ventDoNotVent.setActive(VentSetting.DoNotVent.test((VentSetting)setting));
        }));
    }

    @Override
    protected void onDataUpdated() {
        super.onDataUpdated();
        this._bindings.update();
    }

    private Panel vCommandPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(DesiredDimension.Height, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        return p;
    }

    private Panel vBarPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(18, 84);
        p.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(2));
        return p;
    }

    private Panel vSeparatorPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        Static s = new Static((ModContainerScreen)this, 1, 84);
        p.setDesiredDimension(11, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        s.setColor(Colour.BLACK);
        s.setLayoutEngineHint(FixedLayoutEngine.hint((int)5, (int)0, (int)1, (int)84));
        p.addControl((IControl)s);
        return p;
    }

    private Panel vTempScalePanel() {
        Panel p = new Panel((ModContainerScreen)this);
        Picture pic = new Picture((ModContainerScreen)this, this.nextGenericName(), CommonIcons.TemperatureScale.get(), 5, 59);
        p.setDesiredDimension(11, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        pic.setLayoutEngineHint(FixedLayoutEngine.hint((int)3, (int)23, (int)5, (int)59));
        p.addControl((IControl)pic);
        return p;
    }

    private Panel hInfoPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(DesiredDimension.Width, 88);
        p.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(1));
        return p;
    }

    private Panel hInfoPanelSlot() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(88, 16);
        p.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setZeroMargins()).setControlsSpacing(3));
        return p;
    }

    private Label infoLabel(String name, String value) {
        Label l = new Label((ModContainerScreen)this, name, value);
        l.setAutoSize(false);
        l.setDesiredDimension(68, 10);
        return l;
    }

    private GaugeBar liquidBar(String name, double maxValue) {
        GaugeBar bar = new GaugeBar((ModContainerScreen)this, name, maxValue, CommonIcons.BarBackground.get());
        bar.setDesiredDimension(18, 66);
        bar.setBackground(CommonIcons.BarBackground.get());
        bar.setPadding(1);
        return bar;
    }

    private SwitchPictureButton ventButton(VentSetting setting) {
        SwitchPictureButton swp = new SwitchPictureButton((ModContainerScreen)this, setting.name(), false, "ventSetting");
        swp.setTag((Object)setting);
        swp.Activated.subscribe(this::onVentSettingChanged);
        swp.enablePaintBlending(true);
        swp.setPadding(1);
        swp.setBackground(CommonIcons.ImageButtonBackground.get());
        switch (setting) {
            case VentAll: {
                this.setButtonSpritesAndOverlayForState((AbstractButtonControl)swp, ButtonState.Default, CommonIcons.ButtonVentAll);
                this.setButtonSpritesAndOverlayForState((AbstractButtonControl)swp, ButtonState.Active, CommonIcons.ButtonVentAllActive);
                break;
            }
            case VentOverflow: {
                this.setButtonSpritesAndOverlayForState((AbstractButtonControl)swp, ButtonState.Default, CommonIcons.ButtonVentOverflow);
                this.setButtonSpritesAndOverlayForState((AbstractButtonControl)swp, ButtonState.Active, CommonIcons.ButtonVentOverflowActive);
                break;
            }
            case DoNotVent: {
                this.setButtonSpritesAndOverlayForState((AbstractButtonControl)swp, ButtonState.Default, CommonIcons.ButtonVentDoNot);
                this.setButtonSpritesAndOverlayForState((AbstractButtonControl)swp, ButtonState.Active, CommonIcons.ButtonVentDoNotActive);
            }
        }
        return swp;
    }

    private IControl addBarIcon(NonNullSupplier<ISprite> icon, Panel parent) {
        return this.addBarIcon(icon, 16, 16, parent);
    }

    private IControl addBarIcon(NonNullSupplier<ISprite> icon, int width, int height, Panel parent) {
        Picture c = new Picture((ModContainerScreen)this, this.nextGenericName(), (ISprite)icon.get(), width, height);
        c.setDesiredDimension(width, height);
        parent.addControl((IControl)c);
        return c;
    }

    private static Component getFluidName(Optional<Fluid> fluid) {
        return fluid.map(f -> new TranslatableComponent(f.getAttributes().getTranslationKey()).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE)).orElse(TEXT_EMPTY);
    }

    private static String getRotorEfficiencyText(MultiblockTurbine turbine) {
        return String.format("%.1f%%", Float.valueOf(Mth.m_14036_((float)turbine.getRotorEfficiencyLastTick(), (float)0.0f, (float)1.0f) * 100.0f));
    }

    private static String getRotorBladesText(MultiblockTurbine turbine) {
        int numBlades = turbine.getRotorBladesCount();
        int neededBlades = turbine.getFluidConsumedLastTick() / turbine.getVariant().getBaseFluidPerBlade();
        return String.format("%d / %d", numBlades, neededBlades);
    }

    private void onActiveStateChanged(SwitchButton button) {
        this.sendCommandToServer(button.getActive() ? CommonConstants.COMMAND_ACTIVATE : CommonConstants.COMMAND_DEACTIVATE);
    }

    private void onVentSettingChanged(SwitchPictureButton button) {
        this.sendCommandToServer(TurbineControllerEntity.COMMAND_SET_VENT, NBTHelper.nbtSetEnum((CompoundTag)new CompoundTag(), (String)"vent", (Enum)button.getTag().orElse(VentSetting.VentAll)));
    }

    private void onInductorEngagedChanged(SwitchPictureButton button) {
        this.sendCommandToServer(button.getActive() ? TurbineControllerEntity.COMMAND_ENGAGE_COILS : TurbineControllerEntity.COMMAND_DISENGAGE_COILS);
    }

    private void onMaxIntakeRateChanged(NumberInput<Integer> inputControl, int newRate) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("rate", newRate);
        this.sendCommandToServer(TurbineControllerEntity.COMMAND_SET_INTAKERATE, data);
    }

    private void onScram(Button button, Integer mouseButton) {
        this.sendCommandToServer(ReactorControllerEntity.COMMAND_SCRAM);
    }

    private final <Value> void addBinding(Function<MultiblockTurbine, Value> supplier, Consumer<Value> consumer) {
        this._bindings.addBinding((IBinding)new MonoConsumerBinding((Object)this._turbine, supplier, consumer));
    }

    @SafeVarargs
    private final <Value> void addBinding(Function<MultiblockTurbine, Value> supplier, Consumer<Value> ... consumers) {
        this._bindings.addBinding((IBinding)new MultiConsumerBinding((Object)this._turbine, supplier, (Consumer[])consumers));
    }
}

