/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.upgrade;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.api.room.upgrade.ILevelLoadedUpgradeListener;
import dev.compactmods.machines.api.room.upgrade.RoomUpgrade;
import java.util.Comparator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ChunkloadUpgrade
extends ForgeRegistryEntry<RoomUpgrade>
implements RoomUpgrade,
ILevelLoadedUpgradeListener {
    public static final ResourceLocation REG_ID = new ResourceLocation("compactmachines", "chunkloader");
    private static final TicketType<ChunkPos> CM4_LOAD_TYPE = TicketType.m_9462_((String)"compactmachines:rooms", Comparator.comparingLong(ChunkPos::m_45588_));
    private static final Codec<ChunkloadUpgrade> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.f_135803_.fieldOf("type").forGetter(x -> REG_ID)).apply((Applicative)i, t -> new ChunkloadUpgrade()));

    @Override
    public void onAdded(ServerLevel level, ChunkPos room) {
        this.forceLoad(level, room);
    }

    @Override
    public void onRemoved(ServerLevel level, ChunkPos room) {
        this.normalLoad(level, room);
    }

    @Override
    public void onLevelLoaded(ServerLevel level, ChunkPos room) {
        this.forceLoad(level, room);
    }

    @Override
    public void onLevelUnloaded(ServerLevel level, ChunkPos room) {
        this.normalLoad(level, room);
    }

    private void forceLoad(ServerLevel level, ChunkPos room) {
        ServerChunkCache chunks = level.m_7726_();
        level.m_8602_(room.f_45578_, room.f_45579_, true);
        chunks.registerTickingTicket(CM4_LOAD_TYPE, room, 2, (Object)room);
        chunks.m_8419_(false);
    }

    private void normalLoad(ServerLevel level, ChunkPos room) {
        ServerChunkCache chunks = level.m_7726_();
        level.m_8602_(room.f_45578_, room.f_45579_, false);
        chunks.releaseTickingTicket(CM4_LOAD_TYPE, room, 2, (Object)room);
        chunks.m_8419_(false);
    }
}

