/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dev.compactmods.machines.client.gui.widget.PSDIconButton;
import dev.compactmods.machines.client.level.RenderingLevel;
import dev.compactmods.machines.client.render.RenderTypes;
import dev.compactmods.machines.client.render.SuperRenderTypeBuffer;
import dev.compactmods.machines.client.util.TransformingVertexBuilder;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.location.LevelBlockPosition;
import dev.compactmods.machines.room.menu.MachineRoomMenu;
import dev.compactmods.machines.room.network.PlayerStartedRoomTrackingPacket;
import dev.compactmods.machines.room.network.RoomNetworkHandler;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class MachineRoomScreen
extends AbstractContainerScreen<MachineRoomMenu> {
    private final Inventory inv;
    protected double rotateX = 45.0;
    protected double rotateY = 20.0;
    private PSDIconButton psdButton;
    private RenderingLevel renderer;

    public MachineRoomScreen(MachineRoomMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 248;
        this.f_97727_ = 239;
        this.f_97729_ = 5;
        this.inv = inv;
        RoomNetworkHandler.CHANNEL.sendToServer((Object)new PlayerStartedRoomTrackingPacket(menu.getRoom()));
        this.updateBlockRender();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.psdButton = (PSDIconButton)this.m_142416_((GuiEventListener)new PSDIconButton(this, this.f_97735_ + 220, this.f_97736_ + 210));
        if (this.hasPsdItem()) {
            this.psdButton.setEnabled(true);
        }
    }

    public void updateBlockRender() {
        StructureTemplate struct = ((MachineRoomMenu)this.f_97732_).getBlocks();
        this.renderer = new RenderingLevel(struct);
    }

    private boolean hasPsdItem() {
        return this.inv.m_36063_(new ItemStack((ItemLike)Registration.PERSONAL_SHRINKING_DEVICE.get()));
    }

    protected void m_181908_() {
        super.m_181908_();
        this.psdButton.setEnabled(this.inv.f_35978_.m_7500_() || this.hasPsdItem());
        this.renderer.tbe();
    }

    public boolean m_7979_(double mx, double my, int mButton, double dx, double dy) {
        boolean s = super.m_7979_(mx, my, mButton, dx, dy);
        if (!s) {
            return false;
        }
        this.rotateX += dx;
        this.rotateY += dy;
        return true;
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        pose.m_85836_();
        pose.m_85837_(0.0, 0.0, 500.0);
        pose.m_85837_((double)((float)this.f_97726_ / 2.0f), 0.0, 0.0);
        TextComponent p = new TextComponent(((MachineRoomMenu)this.f_97732_).getRoomName());
        Screen.m_93215_((PoseStack)pose, (Font)this.f_96547_, (Component)p, (int)0, (int)this.f_97729_, (int)-1);
        ChunkPos room = ((MachineRoomMenu)this.f_97732_).getRoom();
        TextComponent rt = new TextComponent("(%s, %s)".formatted(room.f_45578_, room.f_45579_));
        pose.m_85841_(0.8f, 0.8f, 0.8f);
        Objects.requireNonNull(this.f_96547_);
        Screen.m_93215_((PoseStack)pose, (Font)this.f_96547_, (Component)rt, (int)0, (int)(this.f_97729_ + 9 + 2), (int)-3355444);
        pose.m_85849_();
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partial) {
        this.m_7333_(pose);
        super.m_6305_(pose, mouseX, mouseY, partial);
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        RenderSystem.m_157183_();
        Matrix4f matrix4f = new Matrix4f(RenderSystem.m_157192_());
        matrix4f.m_162199_(0.0f, 0.0f, 800.0f);
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        PoseStack.Pose lastEntryBeforeTry = pose.m_85850_();
        Entity cam = this.f_96541_.f_91075_;
        try {
            pose.m_85836_();
            pose.m_85837_(0.0, 0.0, -800.0);
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            BlockEntityRenderDispatcher beRenderer = Minecraft.m_91087_().m_167982_();
            StructureTemplate struct = ((MachineRoomMenu)this.f_97732_).getBlocks();
            pose.m_85836_();
            pose.m_85837_((double)this.getGuiLeft() + (double)this.getXSize() / 2.0, (double)(this.getGuiTop() + 135), 150.0);
            float zoom = switch (struct.m_163801_().m_123341_()) {
                case 3 -> 23.5f;
                case 5 -> 19.5f;
                case 7 -> 15.5f;
                case 9 -> 14.5f;
                case 11 -> 11.5f;
                case 13 -> 10.5f;
                default -> 10.5f;
            };
            pose.m_85841_(zoom, -zoom, zoom);
            pose.m_85845_(Vector3f.f_122223_.m_122240_((float)this.rotateY));
            pose.m_85845_(Vector3f.f_122225_.m_122240_((float)this.rotateX));
            Vec3i tSize = struct.m_163801_();
            float s = (float)tSize.m_123341_() / 2.0f;
            pose.m_85837_((double)(-s), (double)(-s + 1.0f), (double)(-s));
            TransformingVertexBuilder transformer = new TransformingVertexBuilder(buffer, RenderTypes.WALLS);
            BoundingBox bb = struct.m_74633_(new StructurePlaceSettings(), BlockPos.f_121853_);
            ArmorStand as = new ArmorStand((Level)this.renderer, 0.0, 0.0, 0.0);
            this.f_96541_.f_91075_ = as;
            BlockPos.m_121919_((BoundingBox)bb).forEach(pos -> {
                BlockEntity be;
                pose.m_85836_();
                pose.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                BlockState state = this.renderer.m_8055_((BlockPos)pos);
                transformer.setOverlay(3);
                EmptyModelData modelData = EmptyModelData.INSTANCE;
                if (state.m_155947_() && (be = this.renderer.m_7702_((BlockPos)pos)) != null) {
                    modelData = be.getModelData();
                    BlockEntityRenderer ber = beRenderer.m_112265_(be);
                    if (ber != null) {
                        ber.m_6922_(be, 1.0f, pose, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_);
                    }
                }
                try {
                    pose.m_85836_();
                    for (RenderType type : RenderType.m_110506_()) {
                        if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                        blockRenderer.renderBatched(state, pos, (BlockAndTintGetter)this.renderer, pose, buffer.m_6299_(type), true, this.renderer.f_46441_, (IModelData)modelData);
                    }
                    pose.m_85849_();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                pose.m_85849_();
            });
            pose.m_85849_();
            pose.m_85849_();
        }
        catch (Exception e) {
            while (lastEntryBeforeTry != pose.m_85850_()) {
                pose.m_85849_();
            }
        }
        this.f_96541_.f_91075_ = cam;
        buffer.draw();
        RenderSystem.m_157424_();
    }

    protected void m_7286_(PoseStack pose, float p_97788_, int p_97789_, int p_97790_) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("compactmachines", "textures/gui/room_menu.png"));
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
    }

    public LevelBlockPosition getMachine() {
        return ((MachineRoomMenu)this.f_97732_).getMachine();
    }
}

