/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.location.LevelBlockPosition;
import dev.compactmods.machines.machine.graph.CompactMachineNode;
import dev.compactmods.machines.machine.graph.DimensionMachineGraph;
import dev.compactmods.machines.machine.graph.legacy.LegacyMachineConnections;
import dev.compactmods.machines.room.graph.CompactMachineRoomNode;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class CompactMachineBlockEntity
extends BlockEntity {
    private static final String ROOM_NBT = "room_pos";
    private static final String LEGACY_MACH_ID = "machine_id";
    public long nextSpawnTick = 0L;
    protected UUID owner;
    protected String schema;
    protected boolean locked = false;
    private ChunkPos roomChunk;
    private int legacyMachineId = -1;
    private WeakReference<CompactMachineNode> graphNode;
    private WeakReference<CompactMachineRoomNode> roomNode;

    public CompactMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.MACHINE_TILE_ENTITY.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            return this.getConnectedRoom().map(roomId -> {
                try {
                    MinecraftServer serv = sl.m_142572_();
                    ServerLevel compactDim = serv.m_129880_(Registration.COMPACT_DIMENSION);
                    TunnelConnectionGraph graph = TunnelConnectionGraph.forRoom(compactDim, roomId);
                    Stream<BlockPos> supportingTunnels = graph.getTunnelsSupporting(this.getLevelPosition(), side, cap);
                    Optional<BlockPos> firstSupported = supportingTunnels.findFirst();
                    if (firstSupported.isEmpty()) {
                        return super.getCapability(cap, side);
                    }
                    ServerLevel compact = serv.m_129880_(Registration.COMPACT_DIMENSION);
                    if (compact == null) {
                        throw new MissingDimensionException();
                    }
                    BlockEntity patt3069$temp = compact.m_7702_(firstSupported.get());
                    if (patt3069$temp instanceof TunnelWallEntity) {
                        TunnelWallEntity tunnel = (TunnelWallEntity)patt3069$temp;
                        return tunnel.getTunnelCapability(cap, side);
                    }
                    return super.getCapability(cap, side);
                }
                catch (MissingDimensionException e) {
                    CompactMachines.LOGGER.fatal((Object)e);
                    return super.getCapability(cap, side);
                }
            }).orElse(super.getCapability(cap, side));
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        if (this.legacyMachineId != -1) {
            this.updateLegacyData();
        }
        this.syncConnectedRoom();
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.owner = nbt.m_128441_("owner") ? nbt.m_128342_("owner") : null;
        if (nbt.m_128441_(LEGACY_MACH_ID)) {
            this.legacyMachineId = nbt.m_128451_(LEGACY_MACH_ID);
        }
        this.nextSpawnTick = nbt.m_128454_("spawntick");
        this.schema = nbt.m_128441_("schema") ? nbt.m_128461_("schema") : null;
        this.locked = nbt.m_128441_("locked") ? nbt.m_128471_("locked") : false;
    }

    private void updateLegacyData() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            try {
                LegacyMachineConnections legacy = LegacyMachineConnections.get(sl.m_142572_());
                DimensionMachineGraph graph = DimensionMachineGraph.forDimension(sl);
                graph.addMachine(this.f_58858_);
                ChunkPos oldRoom = legacy.getConnectedRoom(this.legacyMachineId);
                CompactMachines.LOGGER.info(CompactMachines.CONN_MARKER, "Rebinding machine {} ({}/{}) to room {}", (Object)this.legacyMachineId, (Object)this.f_58858_, (Object)this.f_58857_.m_46472_(), (Object)this.roomChunk);
                this.roomChunk = oldRoom;
                graph.connectMachineToRoom(this.f_58858_, this.roomChunk);
            }
            catch (MissingDimensionException e) {
                CompactMachines.LOGGER.fatal(CompactMachines.CONN_MARKER, "Could not load connection info from legacy data; machine at {} in dimension {} will be unmapped.", (Object)this.f_58858_, (Object)this.f_58857_.m_46472_());
            }
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        if (this.owner != null) {
            nbt.m_128362_("owner", this.owner);
        }
        nbt.m_128356_("spawntick", this.nextSpawnTick);
        if (this.schema != null) {
            nbt.m_128359_("schema", this.schema);
        }
        nbt.m_128379_("locked", this.locked);
    }

    public CompoundTag m_5995_() {
        CompoundTag data = super.m_5995_();
        this.getConnectedRoom().ifPresent(room -> data.m_128385_(ROOM_NBT, new int[]{room.f_45578_, room.f_45579_}));
        if (this.f_58857_ instanceof ServerLevel && this.owner != null) {
            data.m_128362_("owner", this.owner);
        }
        return data;
    }

    public Optional<ChunkPos> getConnectedRoom() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (this.roomChunk != null) {
                return Optional.of(this.roomChunk);
            }
            DimensionMachineGraph graph = DimensionMachineGraph.forDimension(sl);
            Optional<ChunkPos> chunk = graph.getConnectedRoom(this.f_58858_);
            chunk.ifPresent(c -> {
                this.roomChunk = c;
            });
            return chunk;
        }
        return Optional.ofNullable(this.roomChunk);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128441_("players")) {
            CompoundTag compoundTag = tag.m_128469_("players");
        }
        if (tag.m_128441_(ROOM_NBT)) {
            int[] room = tag.m_128465_(ROOM_NBT);
            this.roomChunk = new ChunkPos(room[0], room[1]);
        }
        if (tag.m_128441_("owner")) {
            this.owner = tag.m_128342_("owner");
        }
    }

    public Optional<UUID> getOwnerUUID() {
        return Optional.ofNullable(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public boolean hasPlayersInside() {
        return false;
    }

    public LevelBlockPosition getLevelPosition() {
        return new LevelBlockPosition((ResourceKey<Level>)this.f_58857_.m_46472_(), this.f_58858_);
    }

    public void syncConnectedRoom() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            DimensionMachineGraph graph = DimensionMachineGraph.forDimension(sl);
            graph.getMachineNode(this.f_58858_).ifPresent(node -> {
                this.graphNode = new WeakReference<CompactMachineNode>((CompactMachineNode)node);
            });
            this.getConnectedRoom().flatMap(room -> graph.getRoomNode(this.roomChunk)).ifPresent(roomNode -> {
                this.roomNode = new WeakReference<CompactMachineRoomNode>((CompactMachineRoomNode)roomNode);
            });
            this.m_6596_();
        }
    }

    public void setConnectedRoom(ChunkPos room) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            DimensionMachineGraph dimMachines = DimensionMachineGraph.forDimension(sl);
            dimMachines.connectMachineToRoom(this.f_58858_, room);
            this.syncConnectedRoom();
        }
    }

    public void disconnect() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            DimensionMachineGraph dimMachines = DimensionMachineGraph.forDimension(sl);
            dimMachines.disconnect(this.f_58858_);
            this.roomChunk = null;
            this.graphNode.clear();
            this.m_6596_();
        }
    }
}

