/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.FurnaceRecipeBuilder;
import codechicken.lib.datagen.recipe.RecipeBuilder;
import codechicken.lib.datagen.recipe.ShapedRecipeBuilder;
import codechicken.lib.datagen.recipe.ShapelessRecipeBuilder;
import codechicken.lib.datagen.recipe.SpecialRecipeBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RecipeProvider
implements DataProvider {
    private static final Logger logger = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<ResourceLocation, RecipeBuilder> recipes = new HashMap<ResourceLocation, RecipeBuilder>();
    private final DataGenerator generator;

    public RecipeProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public final void m_6865_(HashCache cache) throws IOException {
        Path path = this.generator.m_123916_();
        this.registerRecipes();
        for (Map.Entry<ResourceLocation, RecipeBuilder> entry : this.recipes.entrySet()) {
            ResourceLocation id = entry.getKey();
            FinishedRecipe finishedRecipe = entry.getValue().build();
            this.saveRecipe(cache, finishedRecipe.m_125966_(), path.resolve("data/" + id.m_135827_() + "/recipes/" + id.m_135815_() + ".json"));
            JsonObject advancement = finishedRecipe.m_5860_();
            if (advancement == null) continue;
            this.saveRecipeAdvancement(cache, advancement, path.resolve("data/" + id.m_135827_() + "/advancements/" + id.m_135815_() + ".json"));
        }
    }

    protected abstract void registerRecipes();

    protected <T extends RecipeBuilder> T builder(T builder) {
        if (this.recipes.containsKey(builder.getId())) {
            throw new IllegalArgumentException("Recipe with id '" + builder.getId() + "' already exists.");
        }
        this.recipes.put(builder.getId(), builder);
        return builder;
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemLike result) {
        return this.builder(ShapedRecipeBuilder.builder(result, 1));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemLike result, int count) {
        return this.builder(ShapedRecipeBuilder.builder(new ItemStack(result, count)));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemLike result, int count, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.builder(new ItemStack(result, count), id));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemStack result) {
        return this.builder(ShapedRecipeBuilder.builder(result, result.m_41720_().getRegistryName()));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemStack result, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.builder(result, id));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemLike result) {
        return this.builder(ShapelessRecipeBuilder.builder(result, 1));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemLike result, int count) {
        return this.builder(ShapelessRecipeBuilder.builder(new ItemStack(result, count)));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemLike result, int count, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.builder(new ItemStack(result, count), id));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemStack result) {
        return this.builder(ShapelessRecipeBuilder.builder(result, result.m_41720_().getRegistryName()));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemStack result, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.builder(result, id));
    }

    protected FurnaceRecipeBuilder smelting(ItemLike result) {
        return this.builder(FurnaceRecipeBuilder.smelting(result, 1));
    }

    protected FurnaceRecipeBuilder smelting(ItemLike result, int count) {
        return this.builder(FurnaceRecipeBuilder.smelting(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder smelting(ItemLike result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smelting(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder smelting(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.smelting(result, result.m_41720_().getRegistryName()));
    }

    protected FurnaceRecipeBuilder smelting(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smelting(result, id));
    }

    protected FurnaceRecipeBuilder blasting(ItemLike result) {
        return this.builder(FurnaceRecipeBuilder.blasting(result, 1));
    }

    protected FurnaceRecipeBuilder blasting(ItemLike result, int count) {
        return this.builder(FurnaceRecipeBuilder.blasting(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder blasting(ItemLike result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.blasting(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder blasting(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.blasting(result, result.m_41720_().getRegistryName()));
    }

    protected FurnaceRecipeBuilder blasting(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.blasting(result, id));
    }

    protected FurnaceRecipeBuilder smoking(ItemLike result) {
        return this.builder(FurnaceRecipeBuilder.smoking(result, 1));
    }

    protected FurnaceRecipeBuilder smoking(ItemLike result, int count) {
        return this.builder(FurnaceRecipeBuilder.smoking(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder smoking(ItemLike result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smoking(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder smoking(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.smoking(result, result.m_41720_().getRegistryName()));
    }

    protected FurnaceRecipeBuilder smoking(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smoking(result, id));
    }

    protected FurnaceRecipeBuilder campfire(ItemLike result) {
        return this.builder(FurnaceRecipeBuilder.campfire(result, 1));
    }

    protected FurnaceRecipeBuilder campfire(ItemLike result, int count) {
        return this.builder(FurnaceRecipeBuilder.campfire(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder campfire(ItemLike result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.campfire(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder campfire(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.campfire(result, result.m_41720_().getRegistryName()));
    }

    protected FurnaceRecipeBuilder campfire(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.campfire(result, id));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, ItemLike result) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, result, 1));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, new ItemStack(result, count)));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, ItemLike result, int count, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, new ItemStack(result, count), id));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, ItemStack result) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, result, result.m_41720_().getRegistryName()));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, ItemStack result, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, result, id));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, ItemLike result) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, result, 1));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, new ItemStack(result, count)));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, ItemLike result, int count, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, new ItemStack(result, count), id));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, ItemStack result) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, result, result.m_41720_().getRegistryName()));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, ItemStack result, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, result, id));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, ItemLike result) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, result, 1));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, ItemLike result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, result, result.m_41720_().getRegistryName()));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, result, id));
    }

    protected SpecialRecipeBuilder special(SimpleRecipeSerializer<?> serializer, String id) {
        return this.builder(SpecialRecipeBuilder.builder(serializer, id));
    }

    protected SpecialRecipeBuilder special(SimpleRecipeSerializer<?> serializer, ResourceLocation id) {
        return this.builder(SpecialRecipeBuilder.builder(serializer, id));
    }

    private void saveRecipe(HashCache cache, JsonObject recipeJson, Path path) {
        try {
            String json = GSON.toJson((JsonElement)recipeJson);
            String hash = f_123918_.hashUnencodedChars((CharSequence)json).toString();
            if (!hash.equals(cache.m_123938_(path)) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(json);
                }
            }
            cache.m_123940_(path, hash);
        }
        catch (IOException e) {
            logger.error("Couldn't save recipe {}", (Object)path, (Object)e);
        }
    }

    private void saveRecipeAdvancement(HashCache cache, JsonObject advancementJson, Path path) {
        try {
            String json = GSON.toJson((JsonElement)advancementJson);
            String hash = f_123918_.hashUnencodedChars((CharSequence)json).toString();
            if (!hash.equals(cache.m_123938_(path)) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(json);
                }
            }
            cache.m_123940_(path, hash);
        }
        catch (IOException e) {
            logger.error("Couldn't save recipe advancement {}", (Object)path, (Object)e);
        }
    }

    protected EnterBlockTrigger.TriggerInstance enteredBlock(Block blockIn) {
        return new EnterBlockTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, blockIn, StatePropertiesPredicate.f_67658_);
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(ItemLike itemIn) {
        return this.hasItem(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemIn}).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(TagKey<Item> tagIn) {
        return this.hasItem(ItemPredicate.Builder.m_45068_().m_204145_(tagIn).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }
}

