/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.StoneStrataHandler;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UnifyTag;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ReplacementMap {
    private final TagMap tagMap;
    private final UnifyConfig unifyConfig;
    private final StoneStrataHandler stoneStrataHandler;
    private final Set<ResourceLocation> warnings;

    public ReplacementMap(TagMap tagMap, StoneStrataHandler stoneStrataHandler, UnifyConfig unifyConfig) {
        this.tagMap = tagMap;
        this.unifyConfig = unifyConfig;
        this.stoneStrataHandler = stoneStrataHandler;
        this.warnings = new HashSet<ResourceLocation>();
    }

    @Nullable
    public UnifyTag<Item> getPreferredTagForItem(ResourceLocation item) {
        Collection<UnifyTag<Item>> tags = this.tagMap.getTags(item);
        if (tags.isEmpty()) {
            return null;
        }
        if (tags.size() > 1 && !this.warnings.contains(item)) {
            AlmostUnified.LOG.warn("Item '{}' has multiple preferred tags '{}' for recipe replacement. This needs to be manually fixed by the user.", (Object)item, tags.stream().map(UnifyTag::location).toList());
            this.warnings.add(item);
        }
        return tags.iterator().next();
    }

    @Nullable
    public ResourceLocation getReplacementForItem(ResourceLocation item) {
        UnifyTag<Item> t = this.getPreferredTagForItem(item);
        if (t == null) {
            return null;
        }
        if (this.stoneStrataHandler.isStoneStrataTag(t)) {
            String stone = this.stoneStrataHandler.getStoneStrata(item);
            return this.getPreferredItemForTag(t, i -> stone.equals(this.stoneStrataHandler.getStoneStrata((ResourceLocation)i)));
        }
        return this.getPreferredItemForTag(t, i -> true);
    }

    @Nullable
    public ResourceLocation getPreferredItemForTag(UnifyTag<Item> tag, Predicate<ResourceLocation> itemFilter) {
        List<ResourceLocation> items = this.tagMap.getItems(tag).stream().filter(itemFilter).sorted(Comparator.comparingInt(value -> value.toString().length())).toList();
        ResourceLocation overrideItem = this.getOverrideForTag(tag, items);
        if (overrideItem != null) {
            return overrideItem;
        }
        for (String modPriority : this.unifyConfig.getModPriorities()) {
            ResourceLocation item = this.findItemByNamespace(items, modPriority);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Nullable
    private ResourceLocation getOverrideForTag(UnifyTag<Item> tag, List<ResourceLocation> items) {
        String priorityOverride = this.unifyConfig.getPriorityOverrides().get(tag.location());
        if (priorityOverride != null) {
            ResourceLocation item = this.findItemByNamespace(items, priorityOverride);
            if (item != null) {
                return item;
            }
            AlmostUnified.LOG.warn("Priority override mod '{}' for tag '{}' does not contain a valid item. Falling back to default priority.", (Object)priorityOverride, (Object)tag.location());
        }
        return null;
    }

    @Nullable
    private ResourceLocation findItemByNamespace(List<ResourceLocation> items, String namespace) {
        for (ResourceLocation item : items) {
            if (!item.m_135827_().equals(namespace)) continue;
            return item;
        }
        return null;
    }
}

