/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.recipe.RecipeLink;
import com.almostreliable.unified.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ClientRecipeTracker
implements Recipe<Container> {
    public static final ResourceLocation ID = Utils.getRL("client_recipe_tracker");
    public static final String RECIPES = "recipes";
    public static final String NAMESPACE = "namespace";
    public static final int UNIFIED_FLAG = 1;
    public static final int DUPLICATE_FLAG = 2;
    public static final RecipeSerializer<ClientRecipeTracker> SERIALIZER = new Serializer();
    public static final RecipeType<ClientRecipeTracker> TYPE = new RecipeType<ClientRecipeTracker>(){

        public String toString() {
            return ID.m_135815_();
        }
    };
    private final ResourceLocation id;
    private final Map<ResourceLocation, ClientRecipeLink> recipes = new HashMap<ResourceLocation, ClientRecipeLink>();
    private final String namespace;

    protected ClientRecipeTracker(ResourceLocation id, String namespace) {
        this.id = id;
        this.namespace = namespace;
    }

    private static String createRaw(boolean isUnified, boolean isDuplicate, String idPath) {
        int flag = 0;
        if (isUnified) {
            flag |= 1;
        }
        if (isDuplicate) {
            flag |= 2;
        }
        return flag + "$" + idPath;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    private void add(ClientRecipeLink clientRecipeLink) {
        this.recipes.put(clientRecipeLink.id(), clientRecipeLink);
    }

    @Nullable
    public ClientRecipeLink getLink(ResourceLocation recipeId) {
        return this.recipes.get(recipeId);
    }

    public record ClientRecipeLink(ResourceLocation id, boolean isUnified, boolean isDuplicate) {
    }

    public static class Serializer
    implements RecipeSerializer<ClientRecipeTracker> {
        public ClientRecipeTracker fromJson(ResourceLocation recipeId, JsonObject json) {
            String namespace = json.get(ClientRecipeTracker.NAMESPACE).getAsString();
            JsonArray recipes = json.get(ClientRecipeTracker.RECIPES).getAsJsonArray();
            ClientRecipeTracker tracker = new ClientRecipeTracker(recipeId, namespace);
            for (JsonElement element : recipes) {
                ClientRecipeLink clientRecipeLink = Serializer.parseRaw(namespace, element.getAsString());
                tracker.add(clientRecipeLink);
            }
            return tracker;
        }

        public ClientRecipeTracker fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.readInt();
            String namespace = buffer.m_130277_();
            ClientRecipeTracker recipe = new ClientRecipeTracker(recipeId, namespace);
            for (int i = 0; i < size; ++i) {
                String raw = buffer.m_130277_();
                ClientRecipeLink clientRecipeLink = Serializer.parseRaw(namespace, raw);
                recipe.add(clientRecipeLink);
            }
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, ClientRecipeTracker recipe) {
            buffer.writeInt(recipe.recipes.size());
            buffer.m_130070_(recipe.namespace);
            for (ClientRecipeLink clientRecipeLink : recipe.recipes.values()) {
                String raw = ClientRecipeTracker.createRaw(clientRecipeLink.isUnified(), clientRecipeLink.isDuplicate(), clientRecipeLink.id().m_135815_());
                buffer.m_130070_(raw);
            }
        }

        private static ClientRecipeLink parseRaw(String namespace, String raw) {
            String[] split = raw.split("\\$", 2);
            int flag = Integer.parseInt(split[0]);
            boolean isUnified = (flag & 1) != 0;
            boolean isDuplicate = (flag & 2) != 0;
            return new ClientRecipeLink(new ResourceLocation(namespace, split[1]), isUnified, isDuplicate);
        }

        public Serializer setRegistryName(ResourceLocation recipeId) {
            return this;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return (Class)Utils.cast(this.getClass());
        }
    }

    public static class RawBuilder {
        private final Map<String, JsonArray> recipesByNamespace = new HashMap<String, JsonArray>();

        public void add(RecipeLink recipe) {
            ResourceLocation recipeId = recipe.getId();
            JsonArray array = this.recipesByNamespace.computeIfAbsent(recipeId.m_135827_(), k -> new JsonArray());
            array.add(ClientRecipeTracker.createRaw(recipe.isUnified(), recipe.hasDuplicateLink(), recipeId.m_135815_()));
        }

        public Map<ResourceLocation, JsonObject> compute() {
            HashMap<ResourceLocation, JsonObject> result = new HashMap<ResourceLocation, JsonObject>();
            this.recipesByNamespace.forEach((namespace, recipes) -> {
                JsonObject json = new JsonObject();
                json.addProperty("type", ID.toString());
                json.addProperty(ClientRecipeTracker.NAMESPACE, namespace);
                json.add(ClientRecipeTracker.RECIPES, (JsonElement)recipes);
                result.put(new ResourceLocation("almostunified", namespace), json);
            });
            return result;
        }
    }
}

