/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.Platform;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.Defaults;
import com.almostreliable.unified.utils.JsonUtils;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class UnifyConfig
extends Config {
    public static final String NAME = "unify";
    private final List<String> modPriorities;
    private final List<String> stoneStrata;
    private final List<String> unbakedTags;
    private final List<String> materials;
    private final Map<ResourceLocation, String> priorityOverrides;
    private final Set<UnifyTag<Item>> ignoredTags;
    private final Set<Pattern> ignoredItems;
    private final Set<Pattern> ignoredRecipeTypes;
    private final Set<Pattern> ignoredRecipes;
    private final boolean hideJeiRei;
    private final Map<ResourceLocation, Boolean> ignoredRecipeTypesCache;

    public UnifyConfig(List<String> modPriorities, List<String> stoneStrata, List<String> unbakedTags, List<String> materials, Map<ResourceLocation, String> priorityOverrides, Set<UnifyTag<Item>> ignoredTags, Set<Pattern> ignoredItems, Set<Pattern> ignoredRecipeTypes, Set<Pattern> ignoredRecipes, boolean hideJeiRei) {
        this.modPriorities = modPriorities;
        this.stoneStrata = stoneStrata;
        this.unbakedTags = unbakedTags;
        this.materials = materials;
        this.priorityOverrides = priorityOverrides;
        this.ignoredTags = ignoredTags;
        this.ignoredItems = ignoredItems;
        this.ignoredRecipeTypes = ignoredRecipeTypes;
        this.ignoredRecipes = ignoredRecipes;
        this.hideJeiRei = hideJeiRei;
        this.ignoredRecipeTypesCache = new HashMap<ResourceLocation, Boolean>();
    }

    public List<String> getModPriorities() {
        return Collections.unmodifiableList(this.modPriorities);
    }

    public List<String> getStoneStrata() {
        return Collections.unmodifiableList(this.stoneStrata);
    }

    public List<UnifyTag<Item>> bakeTags() {
        ArrayList<UnifyTag<Item>> result = new ArrayList<UnifyTag<Item>>();
        for (String tag : this.unbakedTags) {
            for (String material : this.materials) {
                String replace = tag.replace("{material}", material);
                ResourceLocation asRL = ResourceLocation.m_135820_((String)replace);
                if (asRL == null) {
                    AlmostUnified.LOG.warn("Could not bake tag <{}> with material <{}>", (Object)tag, (Object)material);
                    continue;
                }
                UnifyTag<Item> t = UnifyTag.item(asRL);
                if (this.ignoredTags.contains(t)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public List<String> getMaterials() {
        return Collections.unmodifiableList(this.materials);
    }

    public Map<ResourceLocation, String> getPriorityOverrides() {
        return Collections.unmodifiableMap(this.priorityOverrides);
    }

    public boolean includeItem(ResourceLocation item) {
        for (Pattern pattern : this.ignoredItems) {
            if (!pattern.matcher(item.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean includeRecipe(ResourceLocation recipe) {
        for (Pattern pattern : this.ignoredRecipes) {
            if (!pattern.matcher(recipe.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean includeRecipeType(ResourceLocation type) {
        return this.ignoredRecipeTypesCache.computeIfAbsent(type, t -> {
            for (Pattern pattern : this.ignoredRecipeTypes) {
                if (!pattern.matcher(t.toString()).matches()) continue;
                return false;
            }
            return true;
        });
    }

    public boolean reiOrJeiDisabled() {
        return !this.hideJeiRei;
    }

    public void clearCache() {
        this.ignoredRecipeTypesCache.clear();
    }

    public static class Serializer
    extends Config.Serializer<UnifyConfig> {
        public static final String MOD_PRIORITIES = "modPriorities";
        public static final String STONE_STRATA = "stoneStrata";
        public static final String TAGS = "tags";
        public static final String MATERIALS = "materials";
        public static final String PRIORITY_OVERRIDES = "priorityOverrides";
        public static final String IGNORED_TAGS = "ignoredTags";
        public static final String IGNORED_ITEMS = "ignoredItems";
        public static final String IGNORED_RECIPE_TYPES = "ignoredRecipeTypes";
        public static final String IGNORED_RECIPES = "ignoredRecipes";
        public static final String HIDE_JEI_REI = "itemsHidingJeiRei";

        @Override
        public UnifyConfig deserialize(JsonObject json) {
            Platform platform = AlmostUnifiedPlatform.INSTANCE.getPlatform();
            List<String> modPriorities = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(MOD_PRIORITIES)), Defaults.getModPriorities(platform));
            List<String> stoneStrata = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(STONE_STRATA)), Defaults.STONE_STRATA);
            List<String> tags = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(TAGS)), Defaults.getTags(platform));
            List<String> materials = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(MATERIALS)), Defaults.MATERIALS);
            Map priorityOverrides = this.safeGet(() -> json.getAsJsonObject(PRIORITY_OVERRIDES).entrySet().stream().collect(Collectors.toMap(entry -> new ResourceLocation((String)entry.getKey()), entry -> ((JsonElement)entry.getValue()).getAsString(), (a, b) -> b, HashMap::new)), new HashMap());
            Set ignoredTags = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(IGNORED_TAGS)).stream().map(s -> UnifyTag.item(new ResourceLocation(s))).collect(Collectors.toSet()), new HashSet());
            Set<Pattern> ignoredItems = this.deserializePatterns(json, IGNORED_ITEMS, List.of());
            Set<Pattern> ignoredRecipeTypes = this.deserializePatterns(json, IGNORED_RECIPE_TYPES, Defaults.getIgnoredRecipeTypes(platform));
            Set<Pattern> ignoredRecipes = this.deserializePatterns(json, IGNORED_RECIPES, List.of());
            boolean hideJeiRei = this.safeGet(() -> json.getAsJsonPrimitive(HIDE_JEI_REI).getAsBoolean(), true);
            return new UnifyConfig(modPriorities, stoneStrata, tags, materials, priorityOverrides, ignoredTags, ignoredItems, ignoredRecipeTypes, ignoredRecipes, hideJeiRei);
        }

        @Override
        public JsonObject serialize(UnifyConfig config) {
            JsonObject json = new JsonObject();
            json.add(MOD_PRIORITIES, (JsonElement)JsonUtils.toArray(config.modPriorities));
            json.add(STONE_STRATA, (JsonElement)JsonUtils.toArray(config.stoneStrata));
            json.add(TAGS, (JsonElement)JsonUtils.toArray(config.unbakedTags));
            json.add(MATERIALS, (JsonElement)JsonUtils.toArray(config.materials));
            JsonObject priorityOverrides = new JsonObject();
            config.priorityOverrides.forEach((tag, mod) -> priorityOverrides.addProperty(tag.toString(), mod));
            json.add(PRIORITY_OVERRIDES, (JsonElement)priorityOverrides);
            json.add(IGNORED_TAGS, (JsonElement)JsonUtils.toArray(config.ignoredTags.stream().map(UnifyTag::location).map(ResourceLocation::toString).toList()));
            this.serializePatterns(json, IGNORED_ITEMS, config.ignoredItems);
            this.serializePatterns(json, IGNORED_RECIPE_TYPES, config.ignoredRecipeTypes);
            this.serializePatterns(json, IGNORED_RECIPES, config.ignoredRecipes);
            json.addProperty(HIDE_JEI_REI, Boolean.valueOf(config.hideJeiRei));
            return json;
        }
    }
}

