/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorUtils {
    public static int getColorFrom(ResourceLocation location) {
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_);
        if (texture instanceof TextureAtlas) {
            return ColorUtils.getColorFrom(((TextureAtlas)texture).m_118316_(location));
        }
        return 0;
    }

    public static int getColorFrom(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return -1;
        }
        if (sprite.m_118415_() == 0) {
            return -1;
        }
        float total = 0.0f;
        float red = 0.0f;
        float blue = 0.0f;
        float green = 0.0f;
        for (int x = 0; x < sprite.m_118405_(); ++x) {
            for (int y = 0; y < sprite.m_118408_(); ++y) {
                int color = sprite.getPixelRGBA(0, x, y);
                int alpha = color >> 24 & 0xFF;
                total += (float)alpha;
                red += (float)((color & 0xFF) * alpha);
                green += (float)((color >> 8 & 0xFF) * alpha);
                blue += (float)((color >> 16 & 0xFF) * alpha);
            }
        }
        if (total > 0.0f) {
            return FastColor.ARGB32.m_13660_((int)255, (int)((int)(red / total)), (int)((int)(green / total)), (int)((int)(blue / total)));
        }
        return -1;
    }
}

