/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class LaserDrillOreCategory
implements IRecipeCategory<LaserDrillOreRecipe> {
    private IGuiHelper guiHelper;

    public LaserDrillOreCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public ResourceLocation getUid() {
        return IndustrialRecipeTypes.LASER_ORE.getUid();
    }

    public Class<? extends LaserDrillOreRecipe> getRecipeClass() {
        return IndustrialRecipeTypes.LASER_ORE.getRecipeClass();
    }

    public Component getTitle() {
        return new TextComponent("Laser Drill Items");
    }

    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 0, 82, 26).addPadding(0, 60, 35, 35).build();
    }

    public IDrawable getIcon() {
        return null;
    }

    public RecipeType<LaserDrillOreRecipe> getRecipeType() {
        return IndustrialRecipeTypes.LASER_ORE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LaserDrillOreRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 36, 5).addIngredients(recipe.catalyst);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 5).addIngredients(recipe.output);
    }

    public void draw(LaserDrillOreRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrix, double mouseX, double mouseY) {
        int recipeWidth = 152;
        if (recipe.pointer > 0) {
            AssetUtil.drawAsset((PoseStack)matrix, (Screen)Minecraft.m_91087_().f_91080_, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.BUTTON_ARROW_LEFT), (int)0, (int)70);
        }
        if (recipe.pointer < recipe.rarity.length - 1) {
            AssetUtil.drawAsset((PoseStack)matrix, (Screen)Minecraft.m_91087_().f_91080_, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.BUTTON_ARROW_RIGHT), (int)137, (int)70);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("textures/gui/toasts.png"));
        Screen cfr_ignored_0 = Minecraft.m_91087_().f_91080_;
        int n = recipeWidth / 10 * 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        Screen.m_93133_((PoseStack)matrix, (int)n, (int)(30 + (9 + 2) * 3), (float)216.0f, (float)0.0f, (int)20, (int)20, (int)256, (int)256);
        Screen cfr_ignored_1 = Minecraft.m_91087_().f_91080_;
        int n2 = recipeWidth / 10 * 7;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        Screen.m_93133_((PoseStack)matrix, (int)n2, (int)(30 + (9 + 2) * 3), (float)216.0f, (float)0.0f, (int)20, (int)20, (int)256, (int)256);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("forge", "textures/gui/icons.png"));
        Screen screen = Minecraft.m_91087_().f_91080_;
        int n3 = recipeWidth / 10 * 7 + 1;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        screen.m_93228_(matrix, n3, 30 + (9 + 2) * 3 + 3, 0, 16, 16, 16);
        String minY = new TranslatableComponent("text.industrialforegoing.miny").getString() + " " + recipe.rarity[recipe.pointer].depth_min;
        String maxY = new TranslatableComponent("text.industrialforegoing.maxy").getString() + " " + recipe.rarity[recipe.pointer].depth_max;
        String wight = new TranslatableComponent("text.industrialforegoing.weight").getString() + " " + recipe.rarity[recipe.pointer].weight;
        String biomes = new TranslatableComponent("text.industrialforegoing.biomes").getString();
        Minecraft.m_91087_().f_91062_.m_92883_(matrix, ChatFormatting.DARK_GRAY + minY, (float)(recipeWidth / 10), 30.0f, 0);
        Font font = Minecraft.m_91087_().f_91062_;
        String string = ChatFormatting.DARK_GRAY + wight;
        float f = recipeWidth / 10;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        font.m_92883_(matrix, string, f, (float)(30 + (9 + 2)), 0);
        Minecraft.m_91087_().f_91062_.m_92883_(matrix, ChatFormatting.DARK_GRAY + maxY, (float)(recipeWidth / 10 * 6), 30.0f, 0);
        Font font2 = Minecraft.m_91087_().f_91062_;
        String string2 = ChatFormatting.DARK_GRAY + ChatFormatting.UNDERLINE + biomes;
        float f2 = recipeWidth / 2 - Minecraft.m_91087_().f_91062_.m_92895_(biomes) / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        font2.m_92883_(matrix, string2, f2, (float)(30 + (9 + 2) * 2), 0);
    }

    public List<Component> getTooltipStrings(LaserDrillOreRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 0.0 && mouseX < 15.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer > 0) {
            return Collections.singletonList(new TranslatableComponent("text.industrialforegoing.button.jei.prev_rarity"));
        }
        if (mouseX > 137.0 && mouseX < 152.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer < recipe.rarity.length - 1) {
            return Collections.singletonList(new TranslatableComponent("text.industrialforegoing.button.jei.next_rarity"));
        }
        if (mouseX > 26.0 && mouseX < 46.0) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            if (mouseY > (double)(30 + (9 + 2) * 3)) {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                if (mouseY < (double)(30 + (9 + 2) * 3 + 20)) {
                    ArrayList<Component> biomes = new ArrayList<Component>();
                    biomes.add((Component)new TranslatableComponent("text.industrialforegoing.tooltip.whitelisted_biomes").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.GOLD));
                    if (recipe.rarity[recipe.pointer].whitelist.length == 0) {
                        biomes.add((Component)new TextComponent("- Any"));
                    } else {
                        for (ResourceKey registryKey : recipe.rarity[recipe.pointer].whitelist) {
                            biomes.add((Component)new TextComponent("- ").m_7220_((Component)new TranslatableComponent("biome." + registryKey.m_135782_().m_135827_() + "." + registryKey.m_135782_().m_135815_())));
                        }
                    }
                    return biomes;
                }
            }
        }
        if (mouseX > 104.0 && mouseX < 124.0) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            if (mouseY > (double)(30 + (9 + 2) * 3)) {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                if (mouseY < (double)(30 + (9 + 2) * 3 + 20)) {
                    ArrayList<Component> biomes = new ArrayList<Component>();
                    biomes.add((Component)new TranslatableComponent("text.industrialforegoing.tooltip.blacklisted_biomes").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.GOLD));
                    if (recipe.rarity[recipe.pointer].blacklist.length == 0) {
                        biomes.add((Component)new TextComponent("- None"));
                    } else {
                        for (ResourceKey registryKey : recipe.rarity[recipe.pointer].blacklist) {
                            biomes.add((Component)new TextComponent("- ").m_7220_((Component)new TranslatableComponent("biome." + registryKey.m_135782_().m_135827_() + "." + registryKey.m_135782_().m_135815_())));
                        }
                    }
                    return biomes;
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean handleInput(LaserDrillOreRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (mouseX > 0.0 && mouseX < 15.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer > 0) {
            --recipe.pointer;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        if (mouseX > 137.0 && mouseX < 152.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer < recipe.rarity.length - 1) {
            ++recipe.pointer;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return false;
    }
}

