/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.resourceproduction.tile.ILaserBase;
import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.config.machine.resourceproduction.OreLaserBaseConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.ItemStackWeightedItem;
import com.hrznstudio.titanium._impl.TagConfig;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.util.FacingUtil;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class OreLaserBaseTile
extends IndustrialMachineTile<OreLaserBaseTile>
implements ILaserBase<OreLaserBaseTile> {
    @Save
    private ProgressBarComponent<OreLaserBaseTile> work;
    @Save
    private SidedInventoryComponent<OreLaserBaseTile> lens;
    @Save
    private SidedInventoryComponent<OreLaserBaseTile> output;
    @Save
    private int miningDepth;

    public OreLaserBaseTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.ORE_LASER_BASE, blockPos, blockState);
        this.setShowEnergy(false);
        this.miningDepth = this.m_58899_().m_123342_();
        this.work = new ProgressBarComponent<OreLaserBaseTile>(12, 22, 0, OreLaserBaseConfig.maxProgress){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<OreLaserBaseTile>(OreLaserBaseTile.this.work.getPosX(), OreLaserBaseTile.this.work.getPosY(), (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + new TranslatableComponent("tooltip.titanium.progressbar.progress").getString() + ChatFormatting.WHITE + new DecimalFormat().format(OreLaserBaseTile.this.work.getProgress()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(OreLaserBaseTile.this.work.getMaxProgress())));
                        return tooltip;
                    }
                });
            }
        }.setColor(DyeColor.YELLOW).setCanIncrease(oreLaserBaseTile -> true).setProgressIncrease(0).setCanReset(oreLaserBaseTile -> true).setOnStart(() -> {
            int maxProgress = (int)Math.floor((float)OreLaserBaseConfig.maxProgress * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
            this.work.setMaxProgress(maxProgress);
        }).setOnFinishWork(this::onWork);
        this.addProgressBar(this.work);
        this.lens = (SidedInventoryComponent)new SidedInventoryComponent("lens", 30, 24, 6, 0).setColor(DyeColor.BLUE).setRange(2, 3).setSlotLimit(1);
        this.addInventory((InventoryComponent)this.lens);
        this.lens.getFacingModes().keySet().forEach(sideness -> this.lens.getFacingModes().put(sideness, IFacingComponent.FaceMode.NONE));
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 74, 24, 15, 1).setColor(DyeColor.ORANGE).setRange(5, 3).setInputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.output);
        int y = 84;
        this.addButton(new ArrowButtonComponent(53, y, 14, 14, FacingUtil.Sideness.LEFT).setPredicate((playerEntity, compoundNBT) -> {
            this.miningDepth = Math.max(-64, this.miningDepth - 1);
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(126, y, 14, 14, FacingUtil.Sideness.RIGHT).setPredicate((playerEntity, compoundNBT) -> {
            this.miningDepth = Math.min(255, this.miningDepth + 1);
            this.markForUpdate();
        }));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new TextScreenAddon("", 70, 87, false){

            public String getText() {
                return ChatFormatting.DARK_GRAY + new TranslatableComponent("text.industrialforegoing.depth").getString() + OreLaserBaseTile.this.miningDepth;
            }
        });
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.miningDepth == -100) {
            this.miningDepth = this.f_58858_.m_123342_();
        }
    }

    private void onWork() {
        List items;
        if (!ItemStackUtils.isInventoryFull(this.output) && !(items = RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)LaserDrillOreRecipe.SERIALIZER.getRecipeType()).stream().filter(laserDrillOreRecipe -> laserDrillOreRecipe.getValidRarity(((Biome)this.f_58857_.m_204166_(this.f_58858_).m_203334_()).getRegistryName(), this.miningDepth) != null).map(laserDrillOreRecipe -> {
            int weight = laserDrillOreRecipe.getValidRarity((ResourceLocation)((Biome)this.f_58857_.m_204166_((BlockPos)this.f_58858_).m_203334_()).getRegistryName(), (int)this.miningDepth).weight;
            for (int i = 0; i < this.lens.getSlots(); ++i) {
                if (!laserDrillOreRecipe.catalyst.test(this.lens.getStackInSlot(i))) continue;
                weight += OreLaserBaseConfig.catalystModifier;
            }
            ItemStack stack = ItemStack.f_41583_;
            for (String modid : TagConfig.ITEM_PREFERENCE) {
                for (ItemStack matchingStack : laserDrillOreRecipe.output.m_43908_()) {
                    if (!matchingStack.m_41720_().getRegistryName().m_135827_().equals(modid)) continue;
                    stack = matchingStack;
                    break;
                }
                if (stack.m_41619_()) continue;
                break;
            }
            if (stack.m_41619_()) {
                stack = laserDrillOreRecipe.output.m_43908_()[0];
            }
            return new ItemStackWeightedItem(stack.m_41777_(), weight);
        }).collect(Collectors.toList())).isEmpty()) {
            ItemStack stack = ((ItemStackWeightedItem)WeightedRandom.m_146317_((Random)this.f_58857_.m_5822_(), items).get()).getStack();
            ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false);
        }
    }

    public OreLaserBaseTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<OreLaserBaseTile> createEnergyStorage() {
        return new EnergyStorageComponent(0, 4, 10);
    }

    @Override
    public ProgressBarComponent<OreLaserBaseTile> getBar() {
        return this.work;
    }

    @Override
    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.SPEED)) {
            return false;
        }
        return super.canAcceptAugment(augment);
    }
}

