/*
 * Decompiled with CFR 0.152.
 */
package com.ferriarnus.liquidburner.recipe;

import com.ferriarnus.liquidburner.recipe.FluidContainer;
import com.ferriarnus.liquidburner.recipe.RecipeRegistry;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LiquidBurning
implements Recipe<FluidContainer> {
    private final FluidStack fluid;
    private final int burntime;
    private final int superheattime;
    private final ResourceLocation id;
    public static final RecipeSerializer<LiquidBurning> SERIALIZER = new Serializer();

    public LiquidBurning(FluidStack fluid, int burntime, int superheattime, ResourceLocation pRecipeId) {
        this.fluid = fluid;
        this.burntime = burntime;
        this.superheattime = superheattime;
        this.id = pRecipeId;
    }

    public boolean matches(FluidContainer pContainer, Level pLevel) {
        return pContainer.getStack().isFluidEqual(this.fluid);
    }

    public ItemStack assemble(FluidContainer pContainer) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.LIQUIDBURNING.get();
    }

    public int getSuperheattime() {
        return this.superheattime;
    }

    public int getBurntime() {
        return this.burntime;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<LiquidBurning> {
        public LiquidBurning fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            String rl = pSerializedRecipe.get("fluid").getAsString();
            if (!ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(rl))) {
                throw new JsonSyntaxException("Unknown fluid '" + rl + "'");
            }
            FluidStack stack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(rl)), 1000);
            int burntime = pSerializedRecipe.get("burntime").getAsInt();
            int superheattime = 0;
            if (pSerializedRecipe.has("superheattime")) {
                superheattime = pSerializedRecipe.get("superheattime").getAsInt();
            }
            return new LiquidBurning(stack, burntime, superheattime, pRecipeId);
        }

        public LiquidBurning fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ResourceLocation rl = pBuffer.m_130281_();
            if (!ForgeRegistries.FLUIDS.containsKey(rl)) {
                throw new JsonSyntaxException("Unknown fluid '" + rl + "'");
            }
            FluidStack stack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(rl), 1000);
            int burntime = pBuffer.readInt();
            int superheattime = pBuffer.readInt();
            return new LiquidBurning(stack, burntime, superheattime, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, LiquidBurning pRecipe) {
            pBuffer.m_130085_(ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)pRecipe.fluid.getFluid()));
            pBuffer.writeInt(pRecipe.burntime);
            pBuffer.writeInt(pRecipe.superheattime);
        }
    }
}

