/*
 * Decompiled with CFR 0.152.
 */
package com.ferriarnus.liquidburner.mixin;

import com.ferriarnus.liquidburner.BlazeTank;
import com.ferriarnus.liquidburner.Tags;
import com.ferriarnus.liquidburner.recipe.FluidContainer;
import com.ferriarnus.liquidburner.recipe.LiquidBurning;
import com.ferriarnus.liquidburner.recipe.RecipeRegistry;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlazeBurnerBlockEntity.class})
public abstract class BlazeBurnerTileEntityMixin
extends SmartBlockEntity {
    @Unique
    BlazeTank tank = new BlazeTank(1000, fluid -> this.tryConsumeLiquid(), fluid -> fluid.getFluid().m_205067_(Tags.Fuilds.BLAZE_BURNER_FUEL_ALL));
    @Unique
    LazyOptional<IFluidHandler> lazy = LazyOptional.of(() -> this.tank);
    @Shadow
    protected BlazeBurnerBlockEntity.FuelType activeFuel;
    @Shadow
    protected int remainingBurnTime;
    private LiquidBurning lb;

    public BlazeBurnerTileEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private void tryConsumeLiquid() {
        if (this.tank.getFluidAmount() == this.tank.getCapacity()) {
            if (this.recipeFluids()) {
                return;
            }
            BlazeBurnerBlockEntity.FuelType newFuel = BlazeBurnerBlockEntity.FuelType.NONE;
            int newBurnTime = 0;
            if (this.tank.getFluid().getFluid().m_205067_(Tags.Fuilds.BLAZE_BURNER_FUEL_SPECIAL)) {
                newBurnTime = 1000;
                newFuel = BlazeBurnerBlockEntity.FuelType.SPECIAL;
            } else if (this.tank.getFluid().getFluid().m_205067_(Tags.Fuilds.BLAZE_BURNER_FUEL_REGULAR)) {
                newBurnTime = 1600;
                newFuel = BlazeBurnerBlockEntity.FuelType.NORMAL;
            }
            if (newFuel == BlazeBurnerBlockEntity.FuelType.NONE) {
                return;
            }
            if (newFuel.ordinal() < this.activeFuel.ordinal()) {
                return;
            }
            if (this.activeFuel == BlazeBurnerBlockEntity.FuelType.SPECIAL && this.remainingBurnTime > 20) {
                return;
            }
            if (newFuel == this.activeFuel) {
                if (this.remainingBurnTime + newBurnTime > 10000) {
                    return;
                }
                newBurnTime = Mth.m_14045_((int)(this.remainingBurnTime + newBurnTime), (int)0, (int)10000);
            }
            this.activeFuel = newFuel;
            this.remainingBurnTime = newBurnTime;
            if (this.f_58857_.f_46443_) {
                this.spawnParticleBurst(this.activeFuel == BlazeBurnerBlockEntity.FuelType.SPECIAL);
                this.tank.drain(this.tank.getCapacity(), IFluidHandler.FluidAction.EXECUTE);
                return;
            }
            BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
            this.playSound();
            this.updateBlockState();
            if (prev != this.getHeatLevelFromBlock()) {
                this.f_58857_.m_5594_((Player)null, this.m_58899_(), SoundEvents.f_11701_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.nextFloat() * 0.125f, 1.15f - this.f_58857_.f_46441_.nextFloat() * 0.25f);
            }
            this.tank.drain(this.tank.getCapacity(), IFluidHandler.FluidAction.EXECUTE);
            return;
        }
    }

    public boolean recipeFluids() {
        FluidContainer container = new FluidContainer(this.tank.getFluid());
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)RecipeRegistry.LIQUIDBURNING.get(), (Container)container, this.f_58857_);
        if (recipe.isPresent()) {
            BlazeBurnerBlockEntity.FuelType newFuel;
            int newBurnTime;
            this.lb = (LiquidBurning)recipe.get();
            if (this.lb.getSuperheattime() > 0) {
                newBurnTime = this.lb.getSuperheattime();
                newFuel = BlazeBurnerBlockEntity.FuelType.SPECIAL;
            } else {
                newBurnTime = this.lb.getBurntime();
                newFuel = BlazeBurnerBlockEntity.FuelType.NORMAL;
                this.lb = null;
            }
            if (newFuel.ordinal() < this.activeFuel.ordinal()) {
                return true;
            }
            if (this.activeFuel == BlazeBurnerBlockEntity.FuelType.SPECIAL && this.remainingBurnTime > 20) {
                return true;
            }
            if (newFuel == this.activeFuel) {
                if (this.remainingBurnTime + newBurnTime > 10000) {
                    return false;
                }
                newBurnTime = Mth.m_14045_((int)(this.remainingBurnTime + newBurnTime), (int)0, (int)10000);
            }
            this.activeFuel = newFuel;
            this.remainingBurnTime = newBurnTime;
            if (this.f_58857_.f_46443_) {
                this.spawnParticleBurst(this.activeFuel == BlazeBurnerBlockEntity.FuelType.SPECIAL);
                this.tank.drain(this.tank.getCapacity(), IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
            this.playSound();
            this.updateBlockState();
            if (prev != this.getHeatLevelFromBlock()) {
                this.f_58857_.m_5594_((Player)null, this.m_58899_(), SoundEvents.f_11701_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.nextFloat() * 0.125f, 1.15f - this.f_58857_.f_46441_.nextFloat() * 0.25f);
            }
            this.tank.drain(this.tank.getCapacity(), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        this.lb = null;
        return false;
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=5000)}, remap=false)
    public int liquidburner$addBurntime(int constant) {
        if (this.lb != null) {
            int temp = this.lb.getBurntime();
            this.lb = null;
            return temp;
        }
        return constant;
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/simibubi/create/content/processing/burner/BlazeBurnerBlockEntity;updateBlockState()V", shift=At.Shift.BEFORE, ordinal=1)}, method={"tick"}, remap=false)
    public void liquidburner$appendTick(CallbackInfo ci) {
        if (this.remainingBurnTime <= 0) {
            this.tryConsumeLiquid();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"read"}, remap=false)
    public void liquidburner$appendRead(CompoundTag compound, boolean clientPacket, CallbackInfo ci) {
        this.tank.readFromNBT(compound.m_128469_("tank"));
    }

    @Inject(at={@At(value="HEAD")}, method={"write"}, remap=false)
    public void liquidburner$appendWrite(CompoundTag compound, boolean clientPacket, CallbackInfo ci) {
        CompoundTag tag = new CompoundTag();
        this.tank.writeToNBT(tag);
        compound.m_128365_("tank", (Tag)tag);
    }

    @Shadow
    public abstract void updateBlockState();

    @Shadow
    protected abstract void playSound();

    @Shadow
    public abstract BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock();

    @Shadow
    public abstract void spawnParticleBurst(boolean var1);

    @Shadow
    public abstract void tick();

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.lazy.cast();
        }
        return super.getCapability(cap, side);
    }
}

