/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.data;

import de.srendi.advancedperipherals.common.blocks.base.BaseBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStatesAndModelsProvider
extends BlockStateProvider {
    public BlockStatesAndModelsProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "advancedperipherals", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.ENVIRONMENT_DETECTOR.get(), "front");
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.CHAT_BOX.get(), "front");
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.PLAYER_DETECTOR.get(), "side", "front");
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.ME_BRIDGE.get(), "front");
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.RS_BRIDGE.get(), "front");
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.ENERGY_DETECTOR.get(), "front", "back");
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.PERIPHERAL_CASING.get(), new String[0]);
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.AR_CONTROLLER.get(), "front");
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.INVENTORY_MANAGER.get(), "front");
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.REDSTONE_INTEGRATOR.get(), "front");
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.BLOCK_READER.get(), (ModelFile)this.generateModel((Block)de.srendi.advancedperipherals.common.setup.Blocks.BLOCK_READER.get(), false, "north", "south", "east", "west", "up", "down"));
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.GEO_SCANNER.get(), "front");
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.COLONY_INTEGRATOR.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.generateModel((Block)de.srendi.advancedperipherals.common.setup.Blocks.COLONY_INTEGRATOR.get()).texture("particle", this.blockTexture((Block)de.srendi.advancedperipherals.common.setup.Blocks.COLONY_INTEGRATOR.get()))).texture("up", this.blockTexture(Blocks.f_49999_, "top"))).texture("down", this.blockTexture(Blocks.f_49999_, "top")));
        this.peripheralBlock((Block)de.srendi.advancedperipherals.common.setup.Blocks.NBT_STORAGE.get(), "front");
    }

    private void peripheralBlock(Block block, ModelFile file) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int y;
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile(file);
            FrontAndTop orientation = (FrontAndTop)state.m_61143_(BaseBlock.ORIENTATION);
            int x = 0;
            if (orientation.m_122629_().m_122434_() == Direction.Axis.Y) {
                y = (int)(orientation.m_122625_().m_122435_() + 180.0f) % 360;
            } else {
                x = orientation.m_122625_() == Direction.DOWN ? 90 : 270;
                y = (int)(orientation.m_122629_().m_122435_() + 180.0f) % 360;
            }
            builder.rotationX(x);
            builder.rotationY(y);
            return builder.build();
        });
    }

    private void peripheralBlock(Block block, String ... sides) {
        this.peripheralBlock(block, (ModelFile)this.generateModel(block, true, sides));
    }

    private BlockModelBuilder generateModel(Block block, boolean hasNormalSide, String ... sides) {
        ResourceLocation particleTexture = this.blockTexture(block);
        BlockModelBuilder builder = hasNormalSide ? this.generateModel(block) : (BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/cube_all"));
        for (String sideTexture : sides) {
            String side = sideTexture;
            if (side.equals("side")) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    builder.texture(direction.toString(), this.blockTexture(block, sideTexture));
                }
            }
            if (side.equals("north")) {
                particleTexture = this.blockTexture(block, "north");
            }
            if (side.equals("front")) {
                side = "north";
                particleTexture = this.blockTexture(block, "front");
            }
            if (side.equals("back")) {
                side = "south";
            }
            builder.texture(side, this.blockTexture(block, sideTexture));
        }
        builder.texture("particle", particleTexture);
        return builder;
    }

    private BlockModelBuilder generateModel(Block block) {
        return (BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block));
    }

    private ResourceLocation blockTexture(Block block, String offset) {
        ResourceLocation name = block.getRegistryName();
        return new ResourceLocation(name.m_135827_(), "block/" + name.m_135815_() + "_" + offset);
    }

    private String name(Block block) {
        return block.getRegistryName().m_135815_();
    }
}

